<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Handle preflight request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Método não permitido']);
    exit();
}

// Get JSON data
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Validate required fields
$required = ['name', 'email', 'phone', 'projectType'];
foreach ($required as $field) {
    if (empty($data[$field])) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => "Campo obrigatório faltando: $field"]);
        exit();
    }
}

// Sanitize input
$name = filter_var($data['name'], FILTER_SANITIZE_STRING);
$email = filter_var($data['email'], FILTER_SANITIZE_EMAIL);
$phone = filter_var($data['phone'], FILTER_SANITIZE_STRING);
$projectType = filter_var($data['projectType'], FILTER_SANITIZE_STRING);
$message = isset($data['message']) ? filter_var($data['message'], FILTER_SANITIZE_STRING) : '';
$source = isset($data['source']) ? filter_var($data['source'], FILTER_SANITIZE_STRING) : 'website';

// Validate email
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Email inválido']);
    exit();
}

// Email configuration
$to = 'vgsalatiel@gmail.com';
$subject = "Nova Solicitação de Orçamento - " . $projectType;

// Map project types to readable names
$projectTypes = [
    'automacao-completa' => 'Automação Completa',
    'iluminacao-inteligente' => 'Iluminação Inteligente',
    'seguranca' => 'Segurança',
    'audio-video' => 'Audio & Vídeo',
    'climatizacao' => 'Climatização',
    'outro' => 'Outro'
];

$projectTypeName = isset($projectTypes[$projectType]) ? $projectTypes[$projectType] : $projectType;

// Create HTML email
$htmlMessage = "
<!DOCTYPE html>
<html>
<head>
    <meta charset='utf-8'>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: linear-gradient(135deg, #3b82f6 0%, #8b5cf6 100%); color: white; padding: 20px; border-radius: 8px 8px 0 0; }
        .content { background: #f9fafb; padding: 20px; border: 1px solid #e5e7eb; }
        .field { margin-bottom: 15px; }
        .label { font-weight: bold; color: #1f2937; }
        .value { color: #4b5563; margin-top: 5px; }
        .footer { background: #1f2937; color: white; padding: 15px; text-align: center; border-radius: 0 0 8px 8px; font-size: 12px; }
    </style>
</head>
<body>
    <div class='container'>
        <div class='header'>
            <h2>Nova Solicitação de Orçamento</h2>
        </div>
        <div class='content'>
            <div class='field'>
                <div class='label'>Nome:</div>
                <div class='value'>" . htmlspecialchars($name) . "</div>
            </div>
            <div class='field'>
                <div class='label'>E-mail:</div>
                <div class='value'>" . htmlspecialchars($email) . "</div>
            </div>
            <div class='field'>
                <div class='label'>Telefone:</div>
                <div class='value'>" . htmlspecialchars($phone) . "</div>
            </div>
            <div class='field'>
                <div class='label'>Tipo de Projeto:</div>
                <div class='value'>" . htmlspecialchars($projectTypeName) . "</div>
            </div>";

if (!empty($message)) {
    $htmlMessage .= "
            <div class='field'>
                <div class='label'>Mensagem:</div>
                <div class='value'>" . nl2br(htmlspecialchars($message)) . "</div>
            </div>";
}

if (!empty($source)) {
    $htmlMessage .= "
            <div class='field'>
                <div class='label'>Origem:</div>
                <div class='value'>" . htmlspecialchars($source) . "</div>
            </div>";
}

$htmlMessage .= "
        </div>
        <div class='footer'>
            <p>Este email foi enviado automaticamente pelo sistema KRTI Network Solutions</p>
        </div>
    </div>
</body>
</html>";

// Email headers
$headers = "MIME-Version: 1.0\r\n";
$headers .= "Content-Type: text/html; charset=UTF-8\r\n";
$headers .= "From: KRTI Network Solutions <noreply@krti.com.br>\r\n";
$headers .= "Reply-To: " . $email . "\r\n";
$headers .= "X-Mailer: PHP/" . phpversion();

// Send email
$mailSent = mail($to, $subject, $htmlMessage, $headers);

if ($mailSent) {
    http_response_code(200);
    echo json_encode([
        'success' => true,
        'message' => 'Solicitação enviada com sucesso! Entraremos em contato em breve.'
    ]);
} else {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao enviar email. Por favor, tente novamente mais tarde.'
    ]);
}
?>

