<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Formulário de Contato - KRTI Network Solutions</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            background: linear-gradient(135deg, #0f172a 0%, #1e3a8a 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .container {
            background: rgba(15, 23, 42, 0.7);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(59, 130, 246, 0.3);
            border-radius: 16px;
            padding: 40px;
            max-width: 600px;
            width: 100%;
            box-shadow: 0 8px 32px rgba(31, 38, 135, 0.37);
        }
        
        h1 {
            color: #fff;
            margin-bottom: 10px;
            font-size: 2rem;
            background: linear-gradient(135deg, #3b82f6 0%, #8b5cf6 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .subtitle {
            color: #cbd5e1;
            margin-bottom: 30px;
            font-size: 1rem;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        label {
            display: block;
            color: #fff;
            margin-bottom: 8px;
            font-weight: 500;
            font-size: 0.9rem;
        }
        
        label .required {
            color: #ef4444;
        }
        
        input, select, textarea {
            width: 100%;
            padding: 12px;
            border: 1px solid rgba(59, 130, 246, 0.3);
            border-radius: 8px;
            background: rgba(15, 23, 42, 0.5);
            color: #fff;
            font-size: 1rem;
            transition: all 0.3s;
        }
        
        input:focus, select:focus, textarea:focus {
            outline: none;
            border-color: #3b82f6;
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
        }
        
        input::placeholder, textarea::placeholder {
            color: #64748b;
        }
        
        textarea {
            resize: vertical;
            min-height: 120px;
        }
        
        .btn {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #3b82f6 0%, #8b5cf6 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            margin-top: 10px;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(59, 130, 246, 0.4);
        }
        
        .btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }
        
        .alert {
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            display: none;
        }
        
        .alert.success {
            background: rgba(34, 197, 94, 0.2);
            border: 1px solid rgba(34, 197, 94, 0.5);
            color: #86efac;
        }
        
        .alert.error {
            background: rgba(239, 68, 68, 0.2);
            border: 1px solid rgba(239, 68, 68, 0.5);
            color: #fca5a5;
        }
        
        .alert.show {
            display: block;
        }
        
        .info-box {
            background: rgba(59, 130, 246, 0.1);
            border: 1px solid rgba(59, 130, 246, 0.3);
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
            color: #93c5fd;
            font-size: 0.9rem;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Formulário de Contato</h1>
        <p class="subtitle">Preencha o formulário abaixo e nossa equipe entrará em contato em até 24 horas.</p>
        
        <div class="info-box">
            <strong>Email de destino:</strong> vgsalatiel@gmail.com
        </div>
        
        <div id="alert" class="alert"></div>
        
        <form id="contactForm" method="POST" action="send-email.php">
            <div class="form-group">
                <label>Nome <span class="required">*</span></label>
                <input type="text" name="name" required placeholder="Seu nome completo">
            </div>
            
            <div class="form-group">
                <label>E-mail <span class="required">*</span></label>
                <input type="email" name="email" required placeholder="seu@email.com">
            </div>
            
            <div class="form-group">
                <label>Telefone <span class="required">*</span></label>
                <input type="tel" name="phone" required placeholder="(11) 99999-9999">
            </div>
            
            <div class="form-group">
                <label>Tipo de Projeto <span class="required">*</span></label>
                <select name="projectType" required>
                    <option value="">Selecione uma opção</option>
                    <option value="automacao-completa">Automação Completa</option>
                    <option value="iluminacao-inteligente">Iluminação Inteligente</option>
                    <option value="seguranca">Segurança</option>
                    <option value="audio-video">Audio & Vídeo</option>
                    <option value="climatizacao">Climatização</option>
                    <option value="outro">Outro</option>
                </select>
            </div>
            
            <div class="form-group">
                <label>Mensagem</label>
                <textarea name="message" placeholder="Descreva seu projeto e necessidades..."></textarea>
            </div>
            
            <input type="hidden" name="source" value="php-form">
            
            <button type="submit" class="btn" id="submitBtn">Enviar Solicitação</button>
        </form>
    </div>
    
    <script>
        document.getElementById('contactForm').addEventListener('submit', async function(e) {
            e.preventDefault();
            
            const submitBtn = document.getElementById('submitBtn');
            const alert = document.getElementById('alert');
            const formData = new FormData(this);
            
            // Convert FormData to JSON
            const data = {};
            formData.forEach((value, key) => {
                data[key] = value;
            });
            
            // Disable button
            submitBtn.disabled = true;
            submitBtn.textContent = 'Enviando...';
            
            try {
                const response = await fetch('send-email.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify(data)
                });
                
                const result = await response.json();
                
                if (result.success) {
                    alert.className = 'alert success show';
                    alert.textContent = result.message || 'Solicitação enviada com sucesso!';
                    this.reset();
                } else {
                    alert.className = 'alert error show';
                    alert.textContent = result.message || 'Erro ao enviar solicitação.';
                }
            } catch (error) {
                alert.className = 'alert error show';
                alert.textContent = 'Erro ao enviar solicitação. Por favor, tente novamente.';
                console.error('Error:', error);
            } finally {
                submitBtn.disabled = false;
                submitBtn.textContent = 'Enviar Solicitação';
                
                // Scroll to alert
                alert.scrollIntoView({ behavior: 'smooth', block: 'nearest' });
            }
        });
    </script>
</body>
</html>


