import {
  AttachmentContentDisposition,
  AttachmentContentTransferEncoding,
  BehaviorOnMxFailure,
  BounceType,
  BulkEmailStatus,
  ContactLanguage,
  ContactListImportAction,
  DataFormat,
  DeliverabilityDashboardAccountStatus,
  DeliverabilityTestStatus,
  DeliveryEventType,
  DimensionValueSource,
  DkimSigningAttributesOrigin,
  DkimSigningKeyLength,
  DkimStatus,
  EngagementEventType,
  EventType,
  ExportSourceType,
  FeatureStatus,
  HttpsPolicy,
  IdentityType,
  ImportDestinationType,
  JobStatus,
  ListRecommendationsFilterKey,
  ListTenantResourcesFilterKey,
  MailFromDomainStatus,
  MailType,
  Metric,
  MetricAggregation,
  MetricDimensionName,
  MetricNamespace,
  QueryErrorCode,
  RecommendationImpact,
  RecommendationStatus,
  RecommendationType,
  ReputationEntityFilterKey,
  ReputationEntityType,
  ResourceType,
  ReviewStatus,
  ScalingMode,
  SendingStatus,
  Status,
  SubscriptionStatus,
  SuppressionListImportAction,
  SuppressionListReason,
  TlsPolicy,
  VerificationError,
  VerificationStatus,
  WarmupStatus,
} from "./enums";
export interface ReviewDetails {
  Status?: ReviewStatus | undefined;
  CaseId?: string | undefined;
}
export interface AccountDetails {
  MailType?: MailType | undefined;
  WebsiteURL?: string | undefined;
  ContactLanguage?: ContactLanguage | undefined;
  UseCaseDescription?: string | undefined;
  AdditionalContactEmailAddresses?: string[] | undefined;
  ReviewDetails?: ReviewDetails | undefined;
}
export interface ArchivingOptions {
  ArchiveArn?: string | undefined;
}
export interface Attachment {
  RawContent: Uint8Array | undefined;
  ContentDisposition?: AttachmentContentDisposition | undefined;
  FileName: string | undefined;
  ContentDescription?: string | undefined;
  ContentId?: string | undefined;
  ContentTransferEncoding?: AttachmentContentTransferEncoding | undefined;
  ContentType?: string | undefined;
}
export interface BatchGetMetricDataQuery {
  Id: string | undefined;
  Namespace: MetricNamespace | undefined;
  Metric: Metric | undefined;
  Dimensions?: Partial<Record<MetricDimensionName, string>> | undefined;
  StartDate: Date | undefined;
  EndDate: Date | undefined;
}
export interface BatchGetMetricDataRequest {
  Queries: BatchGetMetricDataQuery[] | undefined;
}
export interface MetricDataError {
  Id?: string | undefined;
  Code?: QueryErrorCode | undefined;
  Message?: string | undefined;
}
export interface MetricDataResult {
  Id?: string | undefined;
  Timestamps?: Date[] | undefined;
  Values?: number[] | undefined;
}
export interface BatchGetMetricDataResponse {
  Results?: MetricDataResult[] | undefined;
  Errors?: MetricDataError[] | undefined;
}
export interface BlacklistEntry {
  RblName?: string | undefined;
  ListingTime?: Date | undefined;
  Description?: string | undefined;
}
export interface Content {
  Data: string | undefined;
  Charset?: string | undefined;
}
export interface Body {
  Text?: Content | undefined;
  Html?: Content | undefined;
}
export interface Bounce {
  BounceType?: BounceType | undefined;
  BounceSubType?: string | undefined;
  DiagnosticCode?: string | undefined;
}
export interface MessageHeader {
  Name: string | undefined;
  Value: string | undefined;
}
export interface EmailTemplateContent {
  Subject?: string | undefined;
  Text?: string | undefined;
  Html?: string | undefined;
}
export interface Template {
  TemplateName?: string | undefined;
  TemplateArn?: string | undefined;
  TemplateContent?: EmailTemplateContent | undefined;
  TemplateData?: string | undefined;
  Headers?: MessageHeader[] | undefined;
  Attachments?: Attachment[] | undefined;
}
export interface BulkEmailContent {
  Template?: Template | undefined;
}
export interface Destination {
  ToAddresses?: string[] | undefined;
  CcAddresses?: string[] | undefined;
  BccAddresses?: string[] | undefined;
}
export interface ReplacementTemplate {
  ReplacementTemplateData?: string | undefined;
}
export interface ReplacementEmailContent {
  ReplacementTemplate?: ReplacementTemplate | undefined;
}
export interface MessageTag {
  Name: string | undefined;
  Value: string | undefined;
}
export interface BulkEmailEntry {
  Destination: Destination | undefined;
  ReplacementTags?: MessageTag[] | undefined;
  ReplacementEmailContent?: ReplacementEmailContent | undefined;
  ReplacementHeaders?: MessageHeader[] | undefined;
}
export interface BulkEmailEntryResult {
  Status?: BulkEmailStatus | undefined;
  Error?: string | undefined;
  MessageId?: string | undefined;
}
export interface CancelExportJobRequest {
  JobId: string | undefined;
}
export interface CancelExportJobResponse {}
export interface CloudWatchDimensionConfiguration {
  DimensionName: string | undefined;
  DimensionValueSource: DimensionValueSource | undefined;
  DefaultDimensionValue: string | undefined;
}
export interface CloudWatchDestination {
  DimensionConfigurations: CloudWatchDimensionConfiguration[] | undefined;
}
export interface Complaint {
  ComplaintSubType?: string | undefined;
  ComplaintFeedbackType?: string | undefined;
}
export interface TopicPreference {
  TopicName: string | undefined;
  SubscriptionStatus: SubscriptionStatus | undefined;
}
export interface Contact {
  EmailAddress?: string | undefined;
  TopicPreferences?: TopicPreference[] | undefined;
  TopicDefaultPreferences?: TopicPreference[] | undefined;
  UnsubscribeAll?: boolean | undefined;
  LastUpdatedTimestamp?: Date | undefined;
}
export interface ContactList {
  ContactListName?: string | undefined;
  LastUpdatedTimestamp?: Date | undefined;
}
export interface ContactListDestination {
  ContactListName: string | undefined;
  ContactListImportAction: ContactListImportAction | undefined;
}
export interface DeliveryOptions {
  TlsPolicy?: TlsPolicy | undefined;
  SendingPoolName?: string | undefined;
  MaxDeliverySeconds?: number | undefined;
}
export interface ReputationOptions {
  ReputationMetricsEnabled?: boolean | undefined;
  LastFreshStart?: Date | undefined;
}
export interface SendingOptions {
  SendingEnabled?: boolean | undefined;
}
export interface SuppressionOptions {
  SuppressedReasons?: SuppressionListReason[] | undefined;
}
export interface Tag {
  Key: string | undefined;
  Value: string | undefined;
}
export interface TrackingOptions {
  CustomRedirectDomain: string | undefined;
  HttpsPolicy?: HttpsPolicy | undefined;
}
export interface DashboardOptions {
  EngagementMetrics?: FeatureStatus | undefined;
}
export interface GuardianOptions {
  OptimizedSharedDelivery?: FeatureStatus | undefined;
}
export interface VdmOptions {
  DashboardOptions?: DashboardOptions | undefined;
  GuardianOptions?: GuardianOptions | undefined;
}
export interface CreateConfigurationSetRequest {
  ConfigurationSetName: string | undefined;
  TrackingOptions?: TrackingOptions | undefined;
  DeliveryOptions?: DeliveryOptions | undefined;
  ReputationOptions?: ReputationOptions | undefined;
  SendingOptions?: SendingOptions | undefined;
  Tags?: Tag[] | undefined;
  SuppressionOptions?: SuppressionOptions | undefined;
  VdmOptions?: VdmOptions | undefined;
  ArchivingOptions?: ArchivingOptions | undefined;
}
export interface CreateConfigurationSetResponse {}
export interface EventBridgeDestination {
  EventBusArn: string | undefined;
}
export interface KinesisFirehoseDestination {
  IamRoleArn: string | undefined;
  DeliveryStreamArn: string | undefined;
}
export interface PinpointDestination {
  ApplicationArn?: string | undefined;
}
export interface SnsDestination {
  TopicArn: string | undefined;
}
export interface EventDestinationDefinition {
  Enabled?: boolean | undefined;
  MatchingEventTypes?: EventType[] | undefined;
  KinesisFirehoseDestination?: KinesisFirehoseDestination | undefined;
  CloudWatchDestination?: CloudWatchDestination | undefined;
  SnsDestination?: SnsDestination | undefined;
  EventBridgeDestination?: EventBridgeDestination | undefined;
  PinpointDestination?: PinpointDestination | undefined;
}
export interface CreateConfigurationSetEventDestinationRequest {
  ConfigurationSetName: string | undefined;
  EventDestinationName: string | undefined;
  EventDestination: EventDestinationDefinition | undefined;
}
export interface CreateConfigurationSetEventDestinationResponse {}
export interface CreateContactRequest {
  ContactListName: string | undefined;
  EmailAddress: string | undefined;
  TopicPreferences?: TopicPreference[] | undefined;
  UnsubscribeAll?: boolean | undefined;
  AttributesData?: string | undefined;
}
export interface CreateContactResponse {}
export interface Topic {
  TopicName: string | undefined;
  DisplayName: string | undefined;
  Description?: string | undefined;
  DefaultSubscriptionStatus: SubscriptionStatus | undefined;
}
export interface CreateContactListRequest {
  ContactListName: string | undefined;
  Topics?: Topic[] | undefined;
  Description?: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateContactListResponse {}
export interface CreateCustomVerificationEmailTemplateRequest {
  TemplateName: string | undefined;
  FromEmailAddress: string | undefined;
  TemplateSubject: string | undefined;
  TemplateContent: string | undefined;
  SuccessRedirectionURL: string | undefined;
  FailureRedirectionURL: string | undefined;
}
export interface CreateCustomVerificationEmailTemplateResponse {}
export interface CreateDedicatedIpPoolRequest {
  PoolName: string | undefined;
  Tags?: Tag[] | undefined;
  ScalingMode?: ScalingMode | undefined;
}
export interface CreateDedicatedIpPoolResponse {}
export interface RawMessage {
  Data: Uint8Array | undefined;
}
export interface Message {
  Subject: Content | undefined;
  Body: Body | undefined;
  Headers?: MessageHeader[] | undefined;
  Attachments?: Attachment[] | undefined;
}
export interface EmailContent {
  Simple?: Message | undefined;
  Raw?: RawMessage | undefined;
  Template?: Template | undefined;
}
export interface CreateDeliverabilityTestReportRequest {
  ReportName?: string | undefined;
  FromEmailAddress: string | undefined;
  Content: EmailContent | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateDeliverabilityTestReportResponse {
  ReportId: string | undefined;
  DeliverabilityTestStatus: DeliverabilityTestStatus | undefined;
}
export interface DkimSigningAttributes {
  DomainSigningSelector?: string | undefined;
  DomainSigningPrivateKey?: string | undefined;
  NextSigningKeyLength?: DkimSigningKeyLength | undefined;
  DomainSigningAttributesOrigin?: DkimSigningAttributesOrigin | undefined;
}
export interface CreateEmailIdentityRequest {
  EmailIdentity: string | undefined;
  Tags?: Tag[] | undefined;
  DkimSigningAttributes?: DkimSigningAttributes | undefined;
  ConfigurationSetName?: string | undefined;
}
export interface DkimAttributes {
  SigningEnabled?: boolean | undefined;
  Status?: DkimStatus | undefined;
  Tokens?: string[] | undefined;
  SigningHostedZone?: string | undefined;
  SigningAttributesOrigin?: DkimSigningAttributesOrigin | undefined;
  NextSigningKeyLength?: DkimSigningKeyLength | undefined;
  CurrentSigningKeyLength?: DkimSigningKeyLength | undefined;
  LastKeyGenerationTimestamp?: Date | undefined;
}
export interface CreateEmailIdentityResponse {
  IdentityType?: IdentityType | undefined;
  VerifiedForSendingStatus?: boolean | undefined;
  DkimAttributes?: DkimAttributes | undefined;
}
export interface CreateEmailIdentityPolicyRequest {
  EmailIdentity: string | undefined;
  PolicyName: string | undefined;
  Policy: string | undefined;
}
export interface CreateEmailIdentityPolicyResponse {}
export interface CreateEmailTemplateRequest {
  TemplateName: string | undefined;
  TemplateContent: EmailTemplateContent | undefined;
}
export interface CreateEmailTemplateResponse {}
export interface MessageInsightsFilters {
  FromEmailAddress?: string[] | undefined;
  Destination?: string[] | undefined;
  Subject?: string[] | undefined;
  Isp?: string[] | undefined;
  LastDeliveryEvent?: DeliveryEventType[] | undefined;
  LastEngagementEvent?: EngagementEventType[] | undefined;
}
export interface MessageInsightsDataSource {
  StartDate: Date | undefined;
  EndDate: Date | undefined;
  Include?: MessageInsightsFilters | undefined;
  Exclude?: MessageInsightsFilters | undefined;
  MaxResults?: number | undefined;
}
export interface ExportMetric {
  Name?: Metric | undefined;
  Aggregation?: MetricAggregation | undefined;
}
export interface MetricsDataSource {
  Dimensions: Partial<Record<MetricDimensionName, string[]>> | undefined;
  Namespace: MetricNamespace | undefined;
  Metrics: ExportMetric[] | undefined;
  StartDate: Date | undefined;
  EndDate: Date | undefined;
}
export interface ExportDataSource {
  MetricsDataSource?: MetricsDataSource | undefined;
  MessageInsightsDataSource?: MessageInsightsDataSource | undefined;
}
export interface ExportDestination {
  DataFormat: DataFormat | undefined;
  S3Url?: string | undefined;
}
export interface CreateExportJobRequest {
  ExportDataSource: ExportDataSource | undefined;
  ExportDestination: ExportDestination | undefined;
}
export interface CreateExportJobResponse {
  JobId?: string | undefined;
}
export interface ImportDataSource {
  S3Url: string | undefined;
  DataFormat: DataFormat | undefined;
}
export interface SuppressionListDestination {
  SuppressionListImportAction: SuppressionListImportAction | undefined;
}
export interface ImportDestination {
  SuppressionListDestination?: SuppressionListDestination | undefined;
  ContactListDestination?: ContactListDestination | undefined;
}
export interface CreateImportJobRequest {
  ImportDestination: ImportDestination | undefined;
  ImportDataSource: ImportDataSource | undefined;
}
export interface CreateImportJobResponse {
  JobId?: string | undefined;
}
export interface RouteDetails {
  Region: string | undefined;
}
export interface Details {
  RoutesDetails: RouteDetails[] | undefined;
}
export interface CreateMultiRegionEndpointRequest {
  EndpointName: string | undefined;
  Details: Details | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateMultiRegionEndpointResponse {
  Status?: Status | undefined;
  EndpointId?: string | undefined;
}
export interface CreateTenantRequest {
  TenantName: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateTenantResponse {
  TenantName?: string | undefined;
  TenantId?: string | undefined;
  TenantArn?: string | undefined;
  CreatedTimestamp?: Date | undefined;
  Tags?: Tag[] | undefined;
  SendingStatus?: SendingStatus | undefined;
}
export interface CreateTenantResourceAssociationRequest {
  TenantName: string | undefined;
  ResourceArn: string | undefined;
}
export interface CreateTenantResourceAssociationResponse {}
export interface CustomVerificationEmailTemplateMetadata {
  TemplateName?: string | undefined;
  FromEmailAddress?: string | undefined;
  TemplateSubject?: string | undefined;
  SuccessRedirectionURL?: string | undefined;
  FailureRedirectionURL?: string | undefined;
}
export interface DomainIspPlacement {
  IspName?: string | undefined;
  InboxRawCount?: number | undefined;
  SpamRawCount?: number | undefined;
  InboxPercentage?: number | undefined;
  SpamPercentage?: number | undefined;
}
export interface VolumeStatistics {
  InboxRawCount?: number | undefined;
  SpamRawCount?: number | undefined;
  ProjectedInbox?: number | undefined;
  ProjectedSpam?: number | undefined;
}
export interface DailyVolume {
  StartDate?: Date | undefined;
  VolumeStatistics?: VolumeStatistics | undefined;
  DomainIspPlacements?: DomainIspPlacement[] | undefined;
}
export interface DashboardAttributes {
  EngagementMetrics?: FeatureStatus | undefined;
}
export interface DedicatedIp {
  Ip: string | undefined;
  WarmupStatus: WarmupStatus | undefined;
  WarmupPercentage: number | undefined;
  PoolName?: string | undefined;
}
export interface DedicatedIpPool {
  PoolName: string | undefined;
  ScalingMode: ScalingMode | undefined;
}
export interface DeleteConfigurationSetRequest {
  ConfigurationSetName: string | undefined;
}
export interface DeleteConfigurationSetResponse {}
export interface DeleteConfigurationSetEventDestinationRequest {
  ConfigurationSetName: string | undefined;
  EventDestinationName: string | undefined;
}
export interface DeleteConfigurationSetEventDestinationResponse {}
export interface DeleteContactRequest {
  ContactListName: string | undefined;
  EmailAddress: string | undefined;
}
export interface DeleteContactResponse {}
export interface DeleteContactListRequest {
  ContactListName: string | undefined;
}
export interface DeleteContactListResponse {}
export interface DeleteCustomVerificationEmailTemplateRequest {
  TemplateName: string | undefined;
}
export interface DeleteCustomVerificationEmailTemplateResponse {}
export interface DeleteDedicatedIpPoolRequest {
  PoolName: string | undefined;
}
export interface DeleteDedicatedIpPoolResponse {}
export interface DeleteEmailIdentityRequest {
  EmailIdentity: string | undefined;
}
export interface DeleteEmailIdentityResponse {}
export interface DeleteEmailIdentityPolicyRequest {
  EmailIdentity: string | undefined;
  PolicyName: string | undefined;
}
export interface DeleteEmailIdentityPolicyResponse {}
export interface DeleteEmailTemplateRequest {
  TemplateName: string | undefined;
}
export interface DeleteEmailTemplateResponse {}
export interface DeleteMultiRegionEndpointRequest {
  EndpointName: string | undefined;
}
export interface DeleteMultiRegionEndpointResponse {
  Status?: Status | undefined;
}
export interface DeleteSuppressedDestinationRequest {
  EmailAddress: string | undefined;
}
export interface DeleteSuppressedDestinationResponse {}
export interface DeleteTenantRequest {
  TenantName: string | undefined;
}
export interface DeleteTenantResponse {}
export interface DeleteTenantResourceAssociationRequest {
  TenantName: string | undefined;
  ResourceArn: string | undefined;
}
export interface DeleteTenantResourceAssociationResponse {}
export interface DeliverabilityTestReport {
  ReportId?: string | undefined;
  ReportName?: string | undefined;
  Subject?: string | undefined;
  FromEmailAddress?: string | undefined;
  CreateDate?: Date | undefined;
  DeliverabilityTestStatus?: DeliverabilityTestStatus | undefined;
}
export interface DomainDeliverabilityCampaign {
  CampaignId?: string | undefined;
  ImageUrl?: string | undefined;
  Subject?: string | undefined;
  FromAddress?: string | undefined;
  SendingIps?: string[] | undefined;
  FirstSeenDateTime?: Date | undefined;
  LastSeenDateTime?: Date | undefined;
  InboxCount?: number | undefined;
  SpamCount?: number | undefined;
  ReadRate?: number | undefined;
  DeleteRate?: number | undefined;
  ReadDeleteRate?: number | undefined;
  ProjectedVolume?: number | undefined;
  Esps?: string[] | undefined;
}
export interface InboxPlacementTrackingOption {
  Global?: boolean | undefined;
  TrackedIsps?: string[] | undefined;
}
export interface DomainDeliverabilityTrackingOption {
  Domain?: string | undefined;
  SubscriptionStartDate?: Date | undefined;
  InboxPlacementTrackingOption?: InboxPlacementTrackingOption | undefined;
}
export interface EventDetails {
  Bounce?: Bounce | undefined;
  Complaint?: Complaint | undefined;
}
export interface InsightsEvent {
  Timestamp?: Date | undefined;
  Type?: EventType | undefined;
  Details?: EventDetails | undefined;
}
export interface EmailInsights {
  Destination?: string | undefined;
  Isp?: string | undefined;
  Events?: InsightsEvent[] | undefined;
}
export interface EmailTemplateMetadata {
  TemplateName?: string | undefined;
  CreatedTimestamp?: Date | undefined;
}
export interface EventDestination {
  Name: string | undefined;
  Enabled?: boolean | undefined;
  MatchingEventTypes: EventType[] | undefined;
  KinesisFirehoseDestination?: KinesisFirehoseDestination | undefined;
  CloudWatchDestination?: CloudWatchDestination | undefined;
  SnsDestination?: SnsDestination | undefined;
  EventBridgeDestination?: EventBridgeDestination | undefined;
  PinpointDestination?: PinpointDestination | undefined;
}
export interface ExportJobSummary {
  JobId?: string | undefined;
  ExportSourceType?: ExportSourceType | undefined;
  JobStatus?: JobStatus | undefined;
  CreatedTimestamp?: Date | undefined;
  CompletedTimestamp?: Date | undefined;
}
export interface ExportStatistics {
  ProcessedRecordsCount?: number | undefined;
  ExportedRecordsCount?: number | undefined;
}
export interface FailureInfo {
  FailedRecordsS3Url?: string | undefined;
  ErrorMessage?: string | undefined;
}
export interface GetAccountRequest {}
export interface SendQuota {
  Max24HourSend?: number | undefined;
  MaxSendRate?: number | undefined;
  SentLast24Hours?: number | undefined;
}
export interface SuppressionAttributes {
  SuppressedReasons?: SuppressionListReason[] | undefined;
}
export interface GuardianAttributes {
  OptimizedSharedDelivery?: FeatureStatus | undefined;
}
export interface VdmAttributes {
  VdmEnabled: FeatureStatus | undefined;
  DashboardAttributes?: DashboardAttributes | undefined;
  GuardianAttributes?: GuardianAttributes | undefined;
}
export interface GetAccountResponse {
  DedicatedIpAutoWarmupEnabled?: boolean | undefined;
  EnforcementStatus?: string | undefined;
  ProductionAccessEnabled?: boolean | undefined;
  SendQuota?: SendQuota | undefined;
  SendingEnabled?: boolean | undefined;
  SuppressionAttributes?: SuppressionAttributes | undefined;
  Details?: AccountDetails | undefined;
  VdmAttributes?: VdmAttributes | undefined;
}
export interface GetBlacklistReportsRequest {
  BlacklistItemNames: string[] | undefined;
}
export interface GetBlacklistReportsResponse {
  BlacklistReport: Record<string, BlacklistEntry[]> | undefined;
}
export interface GetConfigurationSetRequest {
  ConfigurationSetName: string | undefined;
}
export interface GetConfigurationSetResponse {
  ConfigurationSetName?: string | undefined;
  TrackingOptions?: TrackingOptions | undefined;
  DeliveryOptions?: DeliveryOptions | undefined;
  ReputationOptions?: ReputationOptions | undefined;
  SendingOptions?: SendingOptions | undefined;
  Tags?: Tag[] | undefined;
  SuppressionOptions?: SuppressionOptions | undefined;
  VdmOptions?: VdmOptions | undefined;
  ArchivingOptions?: ArchivingOptions | undefined;
}
export interface GetConfigurationSetEventDestinationsRequest {
  ConfigurationSetName: string | undefined;
}
export interface GetConfigurationSetEventDestinationsResponse {
  EventDestinations?: EventDestination[] | undefined;
}
export interface GetContactRequest {
  ContactListName: string | undefined;
  EmailAddress: string | undefined;
}
export interface GetContactResponse {
  ContactListName?: string | undefined;
  EmailAddress?: string | undefined;
  TopicPreferences?: TopicPreference[] | undefined;
  TopicDefaultPreferences?: TopicPreference[] | undefined;
  UnsubscribeAll?: boolean | undefined;
  AttributesData?: string | undefined;
  CreatedTimestamp?: Date | undefined;
  LastUpdatedTimestamp?: Date | undefined;
}
export interface GetContactListRequest {
  ContactListName: string | undefined;
}
export interface GetContactListResponse {
  ContactListName?: string | undefined;
  Topics?: Topic[] | undefined;
  Description?: string | undefined;
  CreatedTimestamp?: Date | undefined;
  LastUpdatedTimestamp?: Date | undefined;
  Tags?: Tag[] | undefined;
}
export interface GetCustomVerificationEmailTemplateRequest {
  TemplateName: string | undefined;
}
export interface GetCustomVerificationEmailTemplateResponse {
  TemplateName?: string | undefined;
  FromEmailAddress?: string | undefined;
  TemplateSubject?: string | undefined;
  TemplateContent?: string | undefined;
  SuccessRedirectionURL?: string | undefined;
  FailureRedirectionURL?: string | undefined;
}
export interface GetDedicatedIpRequest {
  Ip: string | undefined;
}
export interface GetDedicatedIpResponse {
  DedicatedIp?: DedicatedIp | undefined;
}
export interface GetDedicatedIpPoolRequest {
  PoolName: string | undefined;
}
export interface GetDedicatedIpPoolResponse {
  DedicatedIpPool?: DedicatedIpPool | undefined;
}
export interface GetDedicatedIpsRequest {
  PoolName?: string | undefined;
  NextToken?: string | undefined;
  PageSize?: number | undefined;
}
export interface GetDedicatedIpsResponse {
  DedicatedIps?: DedicatedIp[] | undefined;
  NextToken?: string | undefined;
}
export interface GetDeliverabilityDashboardOptionsRequest {}
export interface GetDeliverabilityDashboardOptionsResponse {
  DashboardEnabled: boolean | undefined;
  SubscriptionExpiryDate?: Date | undefined;
  AccountStatus?: DeliverabilityDashboardAccountStatus | undefined;
  ActiveSubscribedDomains?: DomainDeliverabilityTrackingOption[] | undefined;
  PendingExpirationSubscribedDomains?:
    | DomainDeliverabilityTrackingOption[]
    | undefined;
}
export interface GetDeliverabilityTestReportRequest {
  ReportId: string | undefined;
}
export interface PlacementStatistics {
  InboxPercentage?: number | undefined;
  SpamPercentage?: number | undefined;
  MissingPercentage?: number | undefined;
  SpfPercentage?: number | undefined;
  DkimPercentage?: number | undefined;
}
export interface IspPlacement {
  IspName?: string | undefined;
  PlacementStatistics?: PlacementStatistics | undefined;
}
export interface GetDeliverabilityTestReportResponse {
  DeliverabilityTestReport: DeliverabilityTestReport | undefined;
  OverallPlacement: PlacementStatistics | undefined;
  IspPlacements: IspPlacement[] | undefined;
  Message?: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface GetDomainDeliverabilityCampaignRequest {
  CampaignId: string | undefined;
}
export interface GetDomainDeliverabilityCampaignResponse {
  DomainDeliverabilityCampaign: DomainDeliverabilityCampaign | undefined;
}
export interface GetDomainStatisticsReportRequest {
  Domain: string | undefined;
  StartDate: Date | undefined;
  EndDate: Date | undefined;
}
export interface OverallVolume {
  VolumeStatistics?: VolumeStatistics | undefined;
  ReadRatePercent?: number | undefined;
  DomainIspPlacements?: DomainIspPlacement[] | undefined;
}
export interface GetDomainStatisticsReportResponse {
  OverallVolume: OverallVolume | undefined;
  DailyVolumes: DailyVolume[] | undefined;
}
export interface GetEmailIdentityRequest {
  EmailIdentity: string | undefined;
}
export interface MailFromAttributes {
  MailFromDomain: string | undefined;
  MailFromDomainStatus: MailFromDomainStatus | undefined;
  BehaviorOnMxFailure: BehaviorOnMxFailure | undefined;
}
export interface SOARecord {
  PrimaryNameServer?: string | undefined;
  AdminEmail?: string | undefined;
  SerialNumber?: number | undefined;
}
export interface VerificationInfo {
  LastCheckedTimestamp?: Date | undefined;
  LastSuccessTimestamp?: Date | undefined;
  ErrorType?: VerificationError | undefined;
  SOARecord?: SOARecord | undefined;
}
export interface GetEmailIdentityResponse {
  IdentityType?: IdentityType | undefined;
  FeedbackForwardingStatus?: boolean | undefined;
  VerifiedForSendingStatus?: boolean | undefined;
  DkimAttributes?: DkimAttributes | undefined;
  MailFromAttributes?: MailFromAttributes | undefined;
  Policies?: Record<string, string> | undefined;
  Tags?: Tag[] | undefined;
  ConfigurationSetName?: string | undefined;
  VerificationStatus?: VerificationStatus | undefined;
  VerificationInfo?: VerificationInfo | undefined;
}
export interface GetEmailIdentityPoliciesRequest {
  EmailIdentity: string | undefined;
}
export interface GetEmailIdentityPoliciesResponse {
  Policies?: Record<string, string> | undefined;
}
export interface GetEmailTemplateRequest {
  TemplateName: string | undefined;
}
export interface GetEmailTemplateResponse {
  TemplateName: string | undefined;
  TemplateContent: EmailTemplateContent | undefined;
}
export interface GetExportJobRequest {
  JobId: string | undefined;
}
export interface GetExportJobResponse {
  JobId?: string | undefined;
  ExportSourceType?: ExportSourceType | undefined;
  JobStatus?: JobStatus | undefined;
  ExportDestination?: ExportDestination | undefined;
  ExportDataSource?: ExportDataSource | undefined;
  CreatedTimestamp?: Date | undefined;
  CompletedTimestamp?: Date | undefined;
  FailureInfo?: FailureInfo | undefined;
  Statistics?: ExportStatistics | undefined;
}
export interface GetImportJobRequest {
  JobId: string | undefined;
}
export interface GetImportJobResponse {
  JobId?: string | undefined;
  ImportDestination?: ImportDestination | undefined;
  ImportDataSource?: ImportDataSource | undefined;
  FailureInfo?: FailureInfo | undefined;
  JobStatus?: JobStatus | undefined;
  CreatedTimestamp?: Date | undefined;
  CompletedTimestamp?: Date | undefined;
  ProcessedRecordsCount?: number | undefined;
  FailedRecordsCount?: number | undefined;
}
export interface GetMessageInsightsRequest {
  MessageId: string | undefined;
}
export interface GetMessageInsightsResponse {
  MessageId?: string | undefined;
  FromEmailAddress?: string | undefined;
  Subject?: string | undefined;
  EmailTags?: MessageTag[] | undefined;
  Insights?: EmailInsights[] | undefined;
}
export interface GetMultiRegionEndpointRequest {
  EndpointName: string | undefined;
}
export interface Route {
  Region: string | undefined;
}
export interface GetMultiRegionEndpointResponse {
  EndpointName?: string | undefined;
  EndpointId?: string | undefined;
  Routes?: Route[] | undefined;
  Status?: Status | undefined;
  CreatedTimestamp?: Date | undefined;
  LastUpdatedTimestamp?: Date | undefined;
}
export interface GetReputationEntityRequest {
  ReputationEntityReference: string | undefined;
  ReputationEntityType: ReputationEntityType | undefined;
}
export interface StatusRecord {
  Status?: SendingStatus | undefined;
  Cause?: string | undefined;
  LastUpdatedTimestamp?: Date | undefined;
}
export interface ReputationEntity {
  ReputationEntityReference?: string | undefined;
  ReputationEntityType?: ReputationEntityType | undefined;
  ReputationManagementPolicy?: string | undefined;
  CustomerManagedStatus?: StatusRecord | undefined;
  AwsSesManagedStatus?: StatusRecord | undefined;
  SendingStatusAggregate?: SendingStatus | undefined;
  ReputationImpact?: RecommendationImpact | undefined;
}
export interface GetReputationEntityResponse {
  ReputationEntity?: ReputationEntity | undefined;
}
export interface GetSuppressedDestinationRequest {
  EmailAddress: string | undefined;
}
export interface SuppressedDestinationAttributes {
  MessageId?: string | undefined;
  FeedbackId?: string | undefined;
}
export interface SuppressedDestination {
  EmailAddress: string | undefined;
  Reason: SuppressionListReason | undefined;
  LastUpdateTime: Date | undefined;
  Attributes?: SuppressedDestinationAttributes | undefined;
}
export interface GetSuppressedDestinationResponse {
  SuppressedDestination: SuppressedDestination | undefined;
}
export interface GetTenantRequest {
  TenantName: string | undefined;
}
export interface Tenant {
  TenantName?: string | undefined;
  TenantId?: string | undefined;
  TenantArn?: string | undefined;
  CreatedTimestamp?: Date | undefined;
  Tags?: Tag[] | undefined;
  SendingStatus?: SendingStatus | undefined;
}
export interface GetTenantResponse {
  Tenant?: Tenant | undefined;
}
export interface IdentityInfo {
  IdentityType?: IdentityType | undefined;
  IdentityName?: string | undefined;
  SendingEnabled?: boolean | undefined;
  VerificationStatus?: VerificationStatus | undefined;
}
export interface ImportJobSummary {
  JobId?: string | undefined;
  ImportDestination?: ImportDestination | undefined;
  JobStatus?: JobStatus | undefined;
  CreatedTimestamp?: Date | undefined;
  ProcessedRecordsCount?: number | undefined;
  FailedRecordsCount?: number | undefined;
}
export interface ListConfigurationSetsRequest {
  NextToken?: string | undefined;
  PageSize?: number | undefined;
}
export interface ListConfigurationSetsResponse {
  ConfigurationSets?: string[] | undefined;
  NextToken?: string | undefined;
}
export interface ListContactListsRequest {
  PageSize?: number | undefined;
  NextToken?: string | undefined;
}
export interface ListContactListsResponse {
  ContactLists?: ContactList[] | undefined;
  NextToken?: string | undefined;
}
export interface TopicFilter {
  TopicName?: string | undefined;
  UseDefaultIfPreferenceUnavailable?: boolean | undefined;
}
export interface ListContactsFilter {
  FilteredStatus?: SubscriptionStatus | undefined;
  TopicFilter?: TopicFilter | undefined;
}
export interface ListContactsRequest {
  ContactListName: string | undefined;
  Filter?: ListContactsFilter | undefined;
  PageSize?: number | undefined;
  NextToken?: string | undefined;
}
export interface ListContactsResponse {
  Contacts?: Contact[] | undefined;
  NextToken?: string | undefined;
}
export interface ListCustomVerificationEmailTemplatesRequest {
  NextToken?: string | undefined;
  PageSize?: number | undefined;
}
export interface ListCustomVerificationEmailTemplatesResponse {
  CustomVerificationEmailTemplates?:
    | CustomVerificationEmailTemplateMetadata[]
    | undefined;
  NextToken?: string | undefined;
}
export interface ListDedicatedIpPoolsRequest {
  NextToken?: string | undefined;
  PageSize?: number | undefined;
}
export interface ListDedicatedIpPoolsResponse {
  DedicatedIpPools?: string[] | undefined;
  NextToken?: string | undefined;
}
export interface ListDeliverabilityTestReportsRequest {
  NextToken?: string | undefined;
  PageSize?: number | undefined;
}
export interface ListDeliverabilityTestReportsResponse {
  DeliverabilityTestReports: DeliverabilityTestReport[] | undefined;
  NextToken?: string | undefined;
}
export interface ListDomainDeliverabilityCampaignsRequest {
  StartDate: Date | undefined;
  EndDate: Date | undefined;
  SubscribedDomain: string | undefined;
  NextToken?: string | undefined;
  PageSize?: number | undefined;
}
export interface ListDomainDeliverabilityCampaignsResponse {
  DomainDeliverabilityCampaigns: DomainDeliverabilityCampaign[] | undefined;
  NextToken?: string | undefined;
}
export interface ListEmailIdentitiesRequest {
  NextToken?: string | undefined;
  PageSize?: number | undefined;
}
export interface ListEmailIdentitiesResponse {
  EmailIdentities?: IdentityInfo[] | undefined;
  NextToken?: string | undefined;
}
export interface ListEmailTemplatesRequest {
  NextToken?: string | undefined;
  PageSize?: number | undefined;
}
export interface ListEmailTemplatesResponse {
  TemplatesMetadata?: EmailTemplateMetadata[] | undefined;
  NextToken?: string | undefined;
}
export interface ListExportJobsRequest {
  NextToken?: string | undefined;
  PageSize?: number | undefined;
  ExportSourceType?: ExportSourceType | undefined;
  JobStatus?: JobStatus | undefined;
}
export interface ListExportJobsResponse {
  ExportJobs?: ExportJobSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListImportJobsRequest {
  ImportDestinationType?: ImportDestinationType | undefined;
  NextToken?: string | undefined;
  PageSize?: number | undefined;
}
export interface ListImportJobsResponse {
  ImportJobs?: ImportJobSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListManagementOptions {
  ContactListName: string | undefined;
  TopicName?: string | undefined;
}
export interface ListMultiRegionEndpointsRequest {
  NextToken?: string | undefined;
  PageSize?: number | undefined;
}
export interface MultiRegionEndpoint {
  EndpointName?: string | undefined;
  Status?: Status | undefined;
  EndpointId?: string | undefined;
  Regions?: string[] | undefined;
  CreatedTimestamp?: Date | undefined;
  LastUpdatedTimestamp?: Date | undefined;
}
export interface ListMultiRegionEndpointsResponse {
  MultiRegionEndpoints?: MultiRegionEndpoint[] | undefined;
  NextToken?: string | undefined;
}
export interface ListRecommendationsRequest {
  Filter?: Partial<Record<ListRecommendationsFilterKey, string>> | undefined;
  NextToken?: string | undefined;
  PageSize?: number | undefined;
}
export interface Recommendation {
  ResourceArn?: string | undefined;
  Type?: RecommendationType | undefined;
  Description?: string | undefined;
  Status?: RecommendationStatus | undefined;
  CreatedTimestamp?: Date | undefined;
  LastUpdatedTimestamp?: Date | undefined;
  Impact?: RecommendationImpact | undefined;
}
export interface ListRecommendationsResponse {
  Recommendations?: Recommendation[] | undefined;
  NextToken?: string | undefined;
}
export interface ListReputationEntitiesRequest {
  Filter?: Partial<Record<ReputationEntityFilterKey, string>> | undefined;
  NextToken?: string | undefined;
  PageSize?: number | undefined;
}
export interface ListReputationEntitiesResponse {
  ReputationEntities?: ReputationEntity[] | undefined;
  NextToken?: string | undefined;
}
export interface ListResourceTenantsRequest {
  ResourceArn: string | undefined;
  PageSize?: number | undefined;
  NextToken?: string | undefined;
}
export interface ResourceTenantMetadata {
  TenantName?: string | undefined;
  TenantId?: string | undefined;
  ResourceArn?: string | undefined;
  AssociatedTimestamp?: Date | undefined;
}
export interface ListResourceTenantsResponse {
  ResourceTenants?: ResourceTenantMetadata[] | undefined;
  NextToken?: string | undefined;
}
export interface ListSuppressedDestinationsRequest {
  Reasons?: SuppressionListReason[] | undefined;
  StartDate?: Date | undefined;
  EndDate?: Date | undefined;
  NextToken?: string | undefined;
  PageSize?: number | undefined;
}
export interface SuppressedDestinationSummary {
  EmailAddress: string | undefined;
  Reason: SuppressionListReason | undefined;
  LastUpdateTime: Date | undefined;
}
export interface ListSuppressedDestinationsResponse {
  SuppressedDestinationSummaries?: SuppressedDestinationSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListTagsForResourceRequest {
  ResourceArn: string | undefined;
}
export interface ListTagsForResourceResponse {
  Tags: Tag[] | undefined;
}
export interface ListTenantResourcesRequest {
  TenantName: string | undefined;
  Filter?: Partial<Record<ListTenantResourcesFilterKey, string>> | undefined;
  PageSize?: number | undefined;
  NextToken?: string | undefined;
}
export interface TenantResource {
  ResourceType?: ResourceType | undefined;
  ResourceArn?: string | undefined;
}
export interface ListTenantResourcesResponse {
  TenantResources?: TenantResource[] | undefined;
  NextToken?: string | undefined;
}
export interface ListTenantsRequest {
  NextToken?: string | undefined;
  PageSize?: number | undefined;
}
export interface TenantInfo {
  TenantName?: string | undefined;
  TenantId?: string | undefined;
  TenantArn?: string | undefined;
  CreatedTimestamp?: Date | undefined;
}
export interface ListTenantsResponse {
  Tenants?: TenantInfo[] | undefined;
  NextToken?: string | undefined;
}
export interface PutAccountDedicatedIpWarmupAttributesRequest {
  AutoWarmupEnabled?: boolean | undefined;
}
export interface PutAccountDedicatedIpWarmupAttributesResponse {}
export interface PutAccountDetailsRequest {
  MailType: MailType | undefined;
  WebsiteURL: string | undefined;
  ContactLanguage?: ContactLanguage | undefined;
  UseCaseDescription?: string | undefined;
  AdditionalContactEmailAddresses?: string[] | undefined;
  ProductionAccessEnabled?: boolean | undefined;
}
export interface PutAccountDetailsResponse {}
export interface PutAccountSendingAttributesRequest {
  SendingEnabled?: boolean | undefined;
}
export interface PutAccountSendingAttributesResponse {}
export interface PutAccountSuppressionAttributesRequest {
  SuppressedReasons?: SuppressionListReason[] | undefined;
}
export interface PutAccountSuppressionAttributesResponse {}
export interface PutAccountVdmAttributesRequest {
  VdmAttributes: VdmAttributes | undefined;
}
export interface PutAccountVdmAttributesResponse {}
export interface PutConfigurationSetArchivingOptionsRequest {
  ConfigurationSetName: string | undefined;
  ArchiveArn?: string | undefined;
}
export interface PutConfigurationSetArchivingOptionsResponse {}
export interface PutConfigurationSetDeliveryOptionsRequest {
  ConfigurationSetName: string | undefined;
  TlsPolicy?: TlsPolicy | undefined;
  SendingPoolName?: string | undefined;
  MaxDeliverySeconds?: number | undefined;
}
export interface PutConfigurationSetDeliveryOptionsResponse {}
export interface PutConfigurationSetReputationOptionsRequest {
  ConfigurationSetName: string | undefined;
  ReputationMetricsEnabled?: boolean | undefined;
}
export interface PutConfigurationSetReputationOptionsResponse {}
export interface PutConfigurationSetSendingOptionsRequest {
  ConfigurationSetName: string | undefined;
  SendingEnabled?: boolean | undefined;
}
export interface PutConfigurationSetSendingOptionsResponse {}
export interface PutConfigurationSetSuppressionOptionsRequest {
  ConfigurationSetName: string | undefined;
  SuppressedReasons?: SuppressionListReason[] | undefined;
}
export interface PutConfigurationSetSuppressionOptionsResponse {}
export interface PutConfigurationSetTrackingOptionsRequest {
  ConfigurationSetName: string | undefined;
  CustomRedirectDomain?: string | undefined;
  HttpsPolicy?: HttpsPolicy | undefined;
}
export interface PutConfigurationSetTrackingOptionsResponse {}
export interface PutConfigurationSetVdmOptionsRequest {
  ConfigurationSetName: string | undefined;
  VdmOptions?: VdmOptions | undefined;
}
export interface PutConfigurationSetVdmOptionsResponse {}
export interface PutDedicatedIpInPoolRequest {
  Ip: string | undefined;
  DestinationPoolName: string | undefined;
}
export interface PutDedicatedIpInPoolResponse {}
export interface PutDedicatedIpPoolScalingAttributesRequest {
  PoolName: string | undefined;
  ScalingMode: ScalingMode | undefined;
}
export interface PutDedicatedIpPoolScalingAttributesResponse {}
export interface PutDedicatedIpWarmupAttributesRequest {
  Ip: string | undefined;
  WarmupPercentage: number | undefined;
}
export interface PutDedicatedIpWarmupAttributesResponse {}
export interface PutDeliverabilityDashboardOptionRequest {
  DashboardEnabled: boolean | undefined;
  SubscribedDomains?: DomainDeliverabilityTrackingOption[] | undefined;
}
export interface PutDeliverabilityDashboardOptionResponse {}
export interface PutEmailIdentityConfigurationSetAttributesRequest {
  EmailIdentity: string | undefined;
  ConfigurationSetName?: string | undefined;
}
export interface PutEmailIdentityConfigurationSetAttributesResponse {}
export interface PutEmailIdentityDkimAttributesRequest {
  EmailIdentity: string | undefined;
  SigningEnabled?: boolean | undefined;
}
export interface PutEmailIdentityDkimAttributesResponse {}
export interface PutEmailIdentityDkimSigningAttributesRequest {
  EmailIdentity: string | undefined;
  SigningAttributesOrigin: DkimSigningAttributesOrigin | undefined;
  SigningAttributes?: DkimSigningAttributes | undefined;
}
export interface PutEmailIdentityDkimSigningAttributesResponse {
  DkimStatus?: DkimStatus | undefined;
  DkimTokens?: string[] | undefined;
  SigningHostedZone?: string | undefined;
}
export interface PutEmailIdentityFeedbackAttributesRequest {
  EmailIdentity: string | undefined;
  EmailForwardingEnabled?: boolean | undefined;
}
export interface PutEmailIdentityFeedbackAttributesResponse {}
export interface PutEmailIdentityMailFromAttributesRequest {
  EmailIdentity: string | undefined;
  MailFromDomain?: string | undefined;
  BehaviorOnMxFailure?: BehaviorOnMxFailure | undefined;
}
export interface PutEmailIdentityMailFromAttributesResponse {}
export interface PutSuppressedDestinationRequest {
  EmailAddress: string | undefined;
  Reason: SuppressionListReason | undefined;
}
export interface PutSuppressedDestinationResponse {}
export interface SendBulkEmailRequest {
  FromEmailAddress?: string | undefined;
  FromEmailAddressIdentityArn?: string | undefined;
  ReplyToAddresses?: string[] | undefined;
  FeedbackForwardingEmailAddress?: string | undefined;
  FeedbackForwardingEmailAddressIdentityArn?: string | undefined;
  DefaultEmailTags?: MessageTag[] | undefined;
  DefaultContent: BulkEmailContent | undefined;
  BulkEmailEntries: BulkEmailEntry[] | undefined;
  ConfigurationSetName?: string | undefined;
  EndpointId?: string | undefined;
  TenantName?: string | undefined;
}
export interface SendBulkEmailResponse {
  BulkEmailEntryResults: BulkEmailEntryResult[] | undefined;
}
export interface SendCustomVerificationEmailRequest {
  EmailAddress: string | undefined;
  TemplateName: string | undefined;
  ConfigurationSetName?: string | undefined;
}
export interface SendCustomVerificationEmailResponse {
  MessageId?: string | undefined;
}
export interface SendEmailRequest {
  FromEmailAddress?: string | undefined;
  FromEmailAddressIdentityArn?: string | undefined;
  Destination?: Destination | undefined;
  ReplyToAddresses?: string[] | undefined;
  FeedbackForwardingEmailAddress?: string | undefined;
  FeedbackForwardingEmailAddressIdentityArn?: string | undefined;
  Content: EmailContent | undefined;
  EmailTags?: MessageTag[] | undefined;
  ConfigurationSetName?: string | undefined;
  EndpointId?: string | undefined;
  TenantName?: string | undefined;
  ListManagementOptions?: ListManagementOptions | undefined;
}
