import { useEffect } from "react";
import Navigation from "@/components/navigation";
import Footer from "@/components/footer";
import AnimateOnScroll from "@/components/animate-on-scroll";
import QuoteForm from "@/components/quote-form";
import { Home, Shield, Lightbulb, Thermometer, Music, Wrench, ArrowRight, CheckCircle } from "lucide-react";

const services = [
  {
    icon: Home,
    title: "Automação Completa",
    description: "Integração completa de iluminação, climatização, segurança e entretenimento em um único sistema inteligente.",
    details: "Nossa solução de automação completa integra todos os sistemas da sua casa em uma plataforma unificada. Com controle centralizado através de keypads, aplicativos móveis ou comandos de voz, você pode gerenciar iluminação, climatização, segurança, entretenimento e muito mais. O sistema aprende seus padrões e se adapta automaticamente, criando um ambiente verdadeiramente inteligente que responde às suas necessidades."
  },
  {
    icon: Shield,
    title: "Segurança Inteligente",
    description: "Sistemas de segurança avançados com câmeras IP, sensores de movimento e controle de acesso integrado.",
    details: "Proteja sua casa com tecnologia de ponta. Nossos sistemas de segurança inteligente incluem câmeras IP de alta definição com visão noturna, sensores de movimento com detecção inteligente, fechaduras eletrônicas, sistemas de alarme integrados e monitoramento 24/7. Receba notificações em tempo real no seu smartphone e tenha controle total mesmo quando estiver longe de casa."
  },
  {
    icon: Lightbulb,
    title: "Iluminação Inteligente",
    description: "Controle total da iluminação com dimmerização, programação de cenas e automação baseada em presença.",
    details: "Transforme a iluminação da sua casa com tecnologia LED inteligente. Crie cenas personalizadas para diferentes momentos do dia, controle a intensidade e temperatura de cor, e economize até 40% de energia. Sensores de presença garantem que as luzes sejam desligadas automaticamente quando não há ninguém, enquanto programações inteligentes ajustam a iluminação conforme a luz natural do ambiente."
  },
  {
    icon: Thermometer,
    title: "Climatização Automática",
    description: "Controle inteligente de ar condicionado e aquecimento com economia de energia e conforto máximo.",
    details: "Mantenha sua casa na temperatura ideal automaticamente. Sistemas de climatização inteligente aprendem suas preferências, detectam quando você está em casa ou ausente, e ajustam a temperatura para máximo conforto e eficiência. Com controle por zonas, cada ambiente pode ter sua temperatura ideal, enquanto o sistema otimiza o consumo de energia em até 30%."
  },
  {
    icon: Music,
    title: "Audio & Vídeo",
    description: "Sistemas de som ambiente, home theater e distribuição de áudio/vídeo para toda a residência.",
    details: "Crie experiências cinematográficas em qualquer ambiente da sua casa. Sistemas de áudio e vídeo distribuídos permitem compartilhar fontes de entretenimento em múltiplos ambientes, com qualidade profissional. Desde home theaters com som surround até sistemas de música ambiente distribuídos, oferecemos soluções completas que se integram perfeitamente com sua smart home."
  },
  {
    icon: Wrench,
    title: "Suporte & Manutenção",
    description: "Suporte técnico especializado, manutenção preventiva e atualizações do sistema para garantir o melhor desempenho.",
    details: "Nossa equipe de suporte técnico está sempre disponível para garantir que seu sistema funcione perfeitamente. Oferecemos manutenção preventiva regular, atualizações de software, suporte remoto e presencial, e treinamento para que você aproveite ao máximo sua smart home. Com suporte 24/7, você tem tranquilidade total."
  },
];

export default function Services() {
  useEffect(() => {
    document.title = "Serviços de Automação Residencial | KRTI Network Solutions";
    
    const metaDescription = document.querySelector('meta[name="description"]');
    if (metaDescription) {
      metaDescription.setAttribute('content', 'Serviços completos de automação residencial: automação completa, segurança inteligente, iluminação, climatização, áudio e vídeo. Suporte técnico especializado 24/7.');
    }
    
    const metaKeywords = document.querySelector('meta[name="keywords"]');
    if (metaKeywords) {
      metaKeywords.setAttribute('content', 'serviços automação residencial, automação completa, segurança inteligente, iluminação inteligente, climatização automática, áudio vídeo, suporte técnico smart home');
    }
    
    const ogTitle = document.querySelector('meta[property="og:title"]');
    if (ogTitle) {
      ogTitle.setAttribute('content', 'Serviços de Automação Residencial | KRTI');
    }
    
    const ogDescription = document.querySelector('meta[property="og:description"]');
    if (ogDescription) {
      ogDescription.setAttribute('content', 'Serviços completos de automação residencial com tecnologia de ponta e suporte especializado.');
    }
  }, []);

  return (
    <div className="min-h-screen bg-background">
      <Navigation />
      <main>
        {/* Hero Section */}
        <section className="relative py-20 lg:py-32 bg-gradient-to-br from-slate-900 via-blue-900 to-slate-900 overflow-hidden">
          <div className="absolute inset-0 tech-gradient"></div>
          <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <AnimateOnScroll direction="up" delay={0.1}>
              <h1 className="text-4xl lg:text-6xl font-bold text-white mb-6">
                <span className="tech-text-gradient">Nossos Serviços</span>
              </h1>
              <p className="text-xl text-gray-300 max-w-3xl mx-auto">
                Soluções completas em automação residencial, desde o projeto até a manutenção, 
                sempre com tecnologia de ponta e atendimento personalizado.
              </p>
            </AnimateOnScroll>
          </div>
        </section>

        {/* Serviços Detalhados */}
        <section className="py-16 lg:py-24 bg-background">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <AnimateOnScroll direction="up" delay={0.1}>
              <div className="text-center mb-16">
                <h2 className="text-3xl lg:text-4xl font-bold mb-4">
                  <span className="tech-text-gradient">Soluções Completas para sua Smart Home</span>
                </h2>
                <p className="text-xl text-foreground/90 max-w-3xl mx-auto">
                  Oferecemos uma gama completa de serviços para transformar sua casa em um ambiente 
                  verdadeiramente inteligente e conectado.
                </p>
              </div>
            </AnimateOnScroll>
            
            <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
              {services.map((service, index) => {
                const Icon = service.icon;
                return (
                  <AnimateOnScroll 
                    key={index}
                    direction="up" 
                    delay={0.1 + index * 0.1}
                  >
                    <div className="glass-tech rounded-2xl p-8 hover:shadow-xl transition-all duration-300 group h-full tech-border-glow">
                      <div className="w-16 h-16 tech-gradient-strong rounded-xl flex items-center justify-center mb-6 group-hover:glow-primary transition-all duration-300 tech-pulse">
                        <Icon className="w-8 h-8 text-primary tech-icon-glow" />
                      </div>
                      <h3 className="text-xl font-semibold text-foreground mb-4">{service.title}</h3>
                      <p className="text-foreground/80 mb-4">
                        {service.description}
                      </p>
                      <div className="border-t border-border pt-4 mt-4">
                        <p className="text-sm text-foreground/70">
                          {service.details}
                        </p>
                      </div>
                      <button className="text-primary font-medium hover:text-blue-400 inline-flex items-center group mt-6">
                        Saiba mais 
                        <ArrowRight className="w-4 h-4 ml-2 group-hover:translate-x-1 transition-transform" />
                      </button>
                    </div>
                  </AnimateOnScroll>
                );
              })}
            </div>
          </div>
        </section>

        {/* Processo de Trabalho */}
        <section className="py-16 lg:py-24 bg-neutral">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <AnimateOnScroll direction="up" delay={0.1}>
              <div className="text-center mb-16">
                <h2 className="text-3xl lg:text-4xl font-bold mb-4">
                  <span className="tech-text-gradient">Nosso Processo</span>
                </h2>
                <p className="text-xl text-foreground/90 max-w-3xl mx-auto">
                  Um processo estruturado que garante resultados excepcionais em cada projeto
                </p>
              </div>
            </AnimateOnScroll>

            <div className="grid md:grid-cols-4 gap-8">
              {[
                { step: "1", title: "Consultoria", desc: "Avaliação das necessidades e criação do projeto personalizado" },
                { step: "2", title: "Planejamento", desc: "Definição de escopo, orçamento e cronograma detalhado" },
                { step: "3", title: "Instalação", desc: "Execução profissional com técnicos certificados" },
                { step: "4", title: "Suporte", desc: "Treinamento, manutenção e suporte contínuo" },
              ].map((item, index) => (
                <AnimateOnScroll key={index} direction="up" delay={0.2 + index * 0.1}>
                  <div className="text-center glass-tech rounded-xl p-6 tech-border-glow">
                    <div className="w-16 h-16 bg-primary/20 rounded-full flex items-center justify-center mx-auto mb-4">
                      <span className="text-2xl font-bold text-primary">{item.step}</span>
                    </div>
                    <h3 className="text-lg font-semibold text-foreground mb-2">{item.title}</h3>
                    <p className="text-foreground/80 text-sm">{item.desc}</p>
                  </div>
                </AnimateOnScroll>
              ))}
            </div>
          </div>
        </section>

        {/* Formulário */}
        <section className="py-16 lg:py-24 bg-background">
          <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <AnimateOnScroll direction="up" delay={0.1}>
              <div className="text-center mb-12">
                <h2 className="text-3xl lg:text-4xl font-bold mb-4">
                  <span className="tech-text-gradient">Solicite um Orçamento</span>
                </h2>
                <p className="text-xl text-foreground/90">
                  Entre em contato e descubra como podemos transformar sua casa com nossos serviços.
                </p>
              </div>
              <QuoteForm source="services-page" />
            </AnimateOnScroll>
          </div>
        </section>
      </main>
      <Footer />
    </div>
  );
}


