import { useEffect } from "react";
import Navigation from "@/components/navigation";
import Footer from "@/components/footer";
import AnimateOnScroll from "@/components/animate-on-scroll";
import QuoteForm from "@/components/quote-form";
import { Star, Medal, UserCheck, Headphones, CheckCircle } from "lucide-react";

const features = [
  "Keypads Prestige e Essence para controle intuitivo",
  "Touch Walls com interface touchscreen elegante",
  "Remote para controle sofisticado sem fio",
  "App móvel com controle total da casa",
  "Inteligência Embrace com automação avançada",
];

const highlights = [
  {
    icon: Medal,
    title: "Revendedor Autorizado",
    description: "Produtos originais com garantia oficial",
  },
  {
    icon: UserCheck,
    title: "Instalação Certificada",
    description: "Técnicos treinados pela Scenario",
  },
  {
    icon: Headphones,
    title: "Suporte Especializado",
    description: "Atendimento técnico dedicado",
  },
];

export default function Products() {
  useEffect(() => {
    document.title = "Produtos Scenario Automation | KRTI Network Solutions";
    
    const metaDescription = document.querySelector('meta[name="description"]');
    if (metaDescription) {
      metaDescription.setAttribute('content', 'Produtos Scenario Automation: Keypads, Touch Walls, Remote e app móvel. Revendedor autorizado com instalação certificada e suporte especializado.');
    }
    
    const metaKeywords = document.querySelector('meta[name="keywords"]');
    if (metaKeywords) {
      metaKeywords.setAttribute('content', 'Scenario Automation, produtos automação residencial, keypads, touch walls, remote, app automação, revendedor Scenario');
    }
    
    const ogTitle = document.querySelector('meta[property="og:title"]');
    if (ogTitle) {
      ogTitle.setAttribute('content', 'Produtos Scenario Automation | KRTI');
    }
    
    const ogDescription = document.querySelector('meta[property="og:description"]');
    if (ogDescription) {
      ogDescription.setAttribute('content', 'Produtos Scenario Automation de última geração para sua smart home.');
    }
  }, []);

  return (
    <div className="min-h-screen bg-background">
      <Navigation />
      <main>
        {/* Hero Section */}
        <section className="relative py-20 lg:py-32 bg-gradient-to-br from-secondary to-slate-800 overflow-hidden">
          <div className="absolute inset-0 tech-gradient"></div>
          <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <AnimateOnScroll direction="up" delay={0.1}>
              <h1 className="text-4xl lg:text-6xl font-bold text-white mb-6">
                <span className="tech-text-gradient">Parceria com Scenario Automation</span>
              </h1>
              <p className="text-xl text-gray-300 max-w-3xl mx-auto">
                Como revendedor autorizado, oferecemos toda a linha de produtos Scenario Automation 
                com garantia oficial e suporte técnico especializado.
              </p>
            </AnimateOnScroll>
          </div>
        </section>

        {/* Produtos Principais */}
        <section className="py-16 lg:py-24 bg-background">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="lg:grid lg:grid-cols-2 lg:gap-12 items-center mb-16">
              <AnimateOnScroll direction="right" delay={0.1}>
                <div className="grid grid-cols-2 gap-4">
                  <img 
                    src="https://scenarioautomation.com/assets/images/kps-596x514.png" 
                    alt="Keypads Scenario Automation Prestige e Essence" 
                    className="rounded-xl shadow-lg w-full h-auto"
                  />
                  <img 
                    src="https://scenarioautomation.com/assets/images/tws-596x514.png" 
                    alt="Touch Wall Scenario Automation interface touchscreen" 
                    className="rounded-xl shadow-lg w-full h-auto"
                  />
                  <img 
                    src="https://scenarioautomation.com/assets/images/remote-596x514.png" 
                    alt="Remote Scenario Automation controle sem fio" 
                    className="rounded-xl shadow-lg w-full h-auto"
                  />
                  <img 
                    src="https://scenarioautomation.com/assets/images/prod4-app.png" 
                    alt="App Scenario Automation controle móvel" 
                    className="rounded-xl shadow-lg w-full h-auto"
                  />
                </div>
              </AnimateOnScroll>
              <AnimateOnScroll direction="left" delay={0.2} className="mt-12 lg:mt-0">
                <div className="glass-tech-strong rounded-2xl p-8 tech-border-glow">
                  <h2 className="text-3xl font-semibold text-white mb-6">
                    <span className="tech-text-gradient">Tecnologia Scenario Automation</span>
                  </h2>
                  <p className="text-gray-200 mb-6 leading-relaxed">
                    A Scenario Automation é reconhecida mundialmente como uma das marcas mais inovadoras 
                    e elegantes em automação residencial. Seus produtos combinam design sofisticado com 
                    tecnologia de ponta, oferecendo a experiência definitiva de casa inteligente.
                  </p>
                  <ul className="space-y-4 text-gray-200">
                    {features.map((feature, index) => (
                      <li key={index} className="flex items-start">
                        <Star className="w-5 h-5 text-accent mr-3 mt-1 flex-shrink-0 tech-icon-glow" />
                        <span>{feature}</span>
                      </li>
                    ))}
                  </ul>
                </div>
              </AnimateOnScroll>
            </div>
          </div>
        </section>

        {/* Destaques */}
        <section className="py-16 lg:py-24 bg-neutral">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <AnimateOnScroll direction="up" delay={0.1}>
              <div className="text-center mb-16">
                <h2 className="text-3xl lg:text-4xl font-bold mb-4">
                  <span className="tech-text-gradient">Por que Escolher Scenario Automation?</span>
                </h2>
              </div>
            </AnimateOnScroll>
            
            <div className="grid md:grid-cols-3 gap-8">
              {highlights.map((highlight, index) => {
                const Icon = highlight.icon;
                return (
                  <AnimateOnScroll 
                    key={index}
                    direction="up" 
                    delay={0.2 + index * 0.1}
                  >
                    <div className="glass-tech rounded-xl p-6 tech-border-glow text-center h-full hover:glow-primary transition-all duration-300">
                      <div className="w-16 h-16 tech-gradient-strong rounded-full flex items-center justify-center mx-auto mb-4 tech-pulse">
                        <Icon className="w-8 h-8 text-accent tech-icon-glow" />
                      </div>
                      <h4 className="text-lg font-semibold text-foreground mb-2">{highlight.title}</h4>
                      <p className="text-foreground/80">{highlight.description}</p>
                    </div>
                  </AnimateOnScroll>
                );
              })}
            </div>
          </div>
        </section>

        {/* Informações Detalhadas */}
        <section className="py-16 lg:py-24 bg-background">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="grid lg:grid-cols-2 gap-12">
              <AnimateOnScroll direction="right" delay={0.1}>
                <div className="glass-tech rounded-2xl p-8 tech-border-glow">
                  <h3 className="text-2xl font-semibold text-foreground mb-6">Keypads Prestige e Essence</h3>
                  <p className="text-foreground/80 mb-4 leading-relaxed">
                    Os keypads Scenario Automation são muito mais do que simples interruptores. São interfaces 
                    elegantes e sofisticadas que permitem controle intuitivo de toda a sua casa inteligente.
                  </p>
                  <ul className="space-y-3 text-foreground/80">
                    <li className="flex items-start">
                      <CheckCircle className="w-5 h-5 text-primary mr-3 mt-1 flex-shrink-0" />
                      <span>Design premium com materiais de alta qualidade</span>
                    </li>
                    <li className="flex items-start">
                      <CheckCircle className="w-5 h-5 text-primary mr-3 mt-1 flex-shrink-0" />
                      <span>Controle de múltiplos sistemas com um único toque</span>
                    </li>
                    <li className="flex items-start">
                      <CheckCircle className="w-5 h-5 text-primary mr-3 mt-1 flex-shrink-0" />
                      <span>Personalização completa de botões e cenas</span>
                    </li>
                  </ul>
                </div>
              </AnimateOnScroll>

              <AnimateOnScroll direction="left" delay={0.2}>
                <div className="glass-tech rounded-2xl p-8 tech-border-glow">
                  <h3 className="text-2xl font-semibold text-foreground mb-6">Touch Walls e Remote</h3>
                  <p className="text-foreground/80 mb-4 leading-relaxed">
                    Interfaces touchscreen elegantes e controles remotos sofisticados oferecem flexibilidade 
                    total no controle da sua casa inteligente.
                  </p>
                  <ul className="space-y-3 text-foreground/80">
                    <li className="flex items-start">
                      <CheckCircle className="w-5 h-5 text-primary mr-3 mt-1 flex-shrink-0" />
                      <span>Touch Walls com telas de alta qualidade</span>
                    </li>
                    <li className="flex items-start">
                      <CheckCircle className="w-5 h-5 text-primary mr-3 mt-1 flex-shrink-0" />
                      <span>Remote ergonômico para controle sem fio</span>
                    </li>
                    <li className="flex items-start">
                      <CheckCircle className="w-5 h-5 text-primary mr-3 mt-1 flex-shrink-0" />
                      <span>App móvel completo para controle total</span>
                    </li>
                  </ul>
                </div>
              </AnimateOnScroll>
            </div>
          </div>
        </section>

        {/* Formulário */}
        <section className="py-16 lg:py-24 bg-neutral">
          <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <AnimateOnScroll direction="up" delay={0.1}>
              <div className="text-center mb-12">
                <h2 className="text-3xl lg:text-4xl font-bold mb-4">
                  <span className="tech-text-gradient">Solicite um Orçamento</span>
                </h2>
                <p className="text-xl text-foreground/90">
                  Entre em contato para conhecer nossos produtos Scenario Automation.
                </p>
              </div>
              <QuoteForm source="products-page" />
            </AnimateOnScroll>
          </div>
        </section>
      </main>
      <Footer />
    </div>
  );
}


