import Navigation from "@/components/navigation";
import Footer from "@/components/footer";
import { Calendar, Clock, ArrowRight } from "lucide-react";
import AnimateOnScroll from "@/components/animate-on-scroll";
import { Link } from "wouter";

interface BlogPost {
  id: string;
  title: string;
  excerpt: string;
  author: string;
  date: string;
  readTime: string;
  category: string;
  image: string;
}

const blogPosts: BlogPost[] = [
  {
    id: "1",
    title: "Como Transformar sua Casa em uma Smart Home Completa",
    excerpt: "Descubra os passos essenciais para transformar sua residência em um ambiente totalmente automatizado e inteligente, com dicas práticas e soluções inovadoras.",
    author: "KRTI Team",
    date: "15 de Janeiro, 2025",
    readTime: "12 min",
    category: "Automação",
    image: "https://images.unsplash.com/photo-1558618666-fcd25c85cd64?w=800&h=600&fit=crop"
  },
  {
    id: "2",
    title: "Iluminação Inteligente: Economia e Conforto em um Sistema",
    excerpt: "Aprenda como a iluminação inteligente pode reduzir seus custos de energia em até 40% enquanto proporciona o máximo conforto e personalização para cada ambiente.",
    author: "KRTI Team",
    date: "10 de Janeiro, 2025",
    readTime: "10 min",
    category: "Iluminação",
    image: "https://images.unsplash.com/photo-1513475382585-d06e58bcb0e0?w=800&h=600&fit=crop"
  },
  {
    id: "3",
    title: "Segurança Inteligente: Proteja sua Casa com Tecnologia de Ponta",
    excerpt: "Conheça as soluções mais avançadas em segurança residencial, incluindo câmeras inteligentes, sensores de movimento e sistemas de alarme integrados.",
    author: "KRTI Team",
    date: "5 de Janeiro, 2025",
    readTime: "11 min",
    category: "Segurança",
    image: "https://images.unsplash.com/photo-1557804506-669a67965ba0?w=800&h=600&fit=crop"
  },
  {
    id: "4",
    title: "Scenario Automation: A Tecnologia que Revoluciona sua Casa",
    excerpt: "Explore as funcionalidades exclusivas da tecnologia Scenario Automation e descubra como ela pode transformar completamente sua experiência de morar.",
    author: "KRTI Team",
    date: "28 de Janeiro, 2025",
    readTime: "12 min",
    category: "Tecnologia",
    image: "https://images.unsplash.com/photo-1484154218962-a197022b5858?w=800&h=600&fit=crop"
  },
  {
    id: "5",
    title: "Climatização Automática: Conforto Inteligente em Todos os Ambientes",
    excerpt: "Entenda como sistemas de climatização inteligente podem manter sua casa na temperatura ideal automaticamente, economizando energia e garantindo conforto.",
    author: "KRTI Team",
    date: "20 de Janeiro, 2025",
    readTime: "11 min",
    category: "Climatização",
    image: "https://images.unsplash.com/photo-1581578731548-c64695cc6952?w=800&h=600&fit=crop"
  },
  {
    id: "6",
    title: "Audio & Vídeo: Transforme sua Casa em um Cinema",
    excerpt: "Descubra como sistemas de áudio e vídeo distribuídos podem transformar qualquer ambiente da sua casa em uma experiência cinematográfica de alta qualidade.",
    author: "KRTI Team",
    date: "15 de Janeiro, 2025",
    readTime: "11 min",
    category: "Audio & Vídeo",
    image: "https://images.unsplash.com/photo-1493225457124-a3eb161ffa5f?w=800&h=600&fit=crop"
  },
  {
    id: "7",
    title: "Economia de Energia com Automação Residencial: Guia Completo",
    excerpt: "Descubra como a automação residencial pode reduzir significativamente seus custos de energia elétrica, com estratégias práticas e tecnologias eficientes.",
    author: "KRTI Team",
    date: "10 de Janeiro, 2025",
    readTime: "11 min",
    category: "Economia",
    image: "https://images.unsplash.com/photo-1466611653911-95081537e5b7?w=800&h=600&fit=crop"
  },
  {
    id: "8",
    title: "Cortinas e Persianas Inteligentes: Conforto e Privacidade Automatizados",
    excerpt: "Explore como cortinas e persianas inteligentes podem melhorar o conforto térmico, privacidade e eficiência energética da sua casa com controle automático.",
    author: "KRTI Team",
    date: "5 de Janeiro, 2025",
    readTime: "10 min",
    category: "Automação",
    image: "https://images.unsplash.com/photo-1586023492125-27b2c045efd7?w=800&h=600&fit=crop"
  },
  {
    id: "9",
    title: "Assistente de Voz e Controle por Comandos: O Futuro da Casa Inteligente",
    excerpt: "Aprenda como assistentes de voz e comandos inteligentes estão revolucionando a forma como interagimos com nossas casas, tornando o controle ainda mais intuitivo.",
    author: "KRTI Team",
    date: "30 de Janeiro, 2025",
    readTime: "10 min",
    category: "Tecnologia",
    image: "https://images.unsplash.com/photo-1558618666-fcd25c85cd64?w=800&h=600&fit=crop"
  },
  {
    id: "10",
    title: "Irrigação Inteligente: Jardins Automatizados e Sustentáveis",
    excerpt: "Descubra como sistemas de irrigação inteligente podem manter seus jardins sempre verdes, economizando água e tempo com programação automática baseada em condições climáticas.",
    author: "KRTI Team",
    date: "25 de Janeiro, 2025",
    readTime: "9 min",
    category: "Automação",
    image: "https://images.unsplash.com/photo-1416879595882-3373a0480b5b?w=800&h=600&fit=crop"
  },
  {
    id: "11",
    title: "Retorno sobre Investimento em Automação Residencial: Vale a Pena?",
    excerpt: "Análise completa sobre o retorno sobre investimento em automação residencial, incluindo economia de energia, valorização do imóvel e aumento da qualidade de vida.",
    author: "KRTI Team",
    date: "20 de Janeiro, 2025",
    readTime: "12 min",
    category: "Investimento",
    image: "https://images.unsplash.com/photo-1454165804606-c3d57bc86b40?w=800&h=600&fit=crop"
  },
  {
    id: "12",
    title: "Smart Home para Idosos: Tecnologia que Melhora a Qualidade de Vida",
    excerpt: "Como a automação residencial pode ajudar idosos a manterem independência e segurança, com soluções adaptadas para necessidades específicas da terceira idade.",
    author: "KRTI Team",
    date: "15 de Janeiro, 2025",
    readTime: "11 min",
    category: "Acessibilidade",
    image: "https://images.unsplash.com/photo-1559027615-cd4628902d4a?w=800&h=600&fit=crop"
  }
];

export default function Blog() {
  return (
    <div className="min-h-screen bg-background">
      <Navigation />
      <main>
        {/* Hero Section do Blog */}
        <section className="relative py-20 lg:py-32 bg-gradient-to-br from-slate-900 via-blue-900 to-slate-900 overflow-hidden">
          <div className="absolute inset-0 tech-gradient"></div>
          <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <AnimateOnScroll direction="up" delay={0.1}>
              <h1 className="text-4xl lg:text-6xl font-bold text-white mb-6">
                <span className="tech-text-gradient">Blog KRTI</span>
              </h1>
              <p className="text-xl text-gray-300 max-w-3xl mx-auto">
                Descubra as últimas tendências em automação residencial, dicas práticas e 
                insights sobre tecnologia para casas inteligentes.
              </p>
            </AnimateOnScroll>
          </div>
        </section>

        {/* Posts do Blog */}
        <section className="py-16 lg:py-24">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
              {blogPosts.map((post, index) => (
                <AnimateOnScroll 
                  key={post.id}
                  direction="up" 
                  delay={0.1 + index * 0.1}
                >
                  <article className="glass-tech rounded-2xl overflow-hidden hover:shadow-xl transition-all duration-300 tech-border-glow group h-full flex flex-col">
                    <div className="relative h-48 overflow-hidden">
                      <img 
                        src={post.image} 
                        alt={post.title}
                        className="w-full h-full object-cover group-hover:scale-110 transition-transform duration-300"
                      />
                      <div className="absolute top-4 left-4">
                        <span className="bg-primary/90 text-white px-3 py-1 rounded-full text-sm font-medium">
                          {post.category}
                        </span>
                      </div>
                    </div>
                    <div className="p-6 flex-1 flex flex-col">
                      <h2 className="text-xl font-semibold text-foreground mb-3 group-hover:text-primary transition-colors">
                        {post.title}
                      </h2>
                      <p className="text-foreground/80 mb-4 flex-1">
                        {post.excerpt}
                      </p>
                      <div className="flex items-center text-sm text-foreground/60 mb-4 space-x-4">
                        <div className="flex items-center">
                          <Calendar className="w-4 h-4 mr-2" />
                          {post.date}
                        </div>
                        <div className="flex items-center">
                          <Clock className="w-4 h-4 mr-2" />
                          {post.readTime}
                        </div>
                      </div>
                      <Link href={`/blog/${post.id}`}>
                        <button className="text-primary font-medium hover:text-blue-400 inline-flex items-center group w-full justify-between">
                          <span>Ler mais</span>
                          <ArrowRight className="w-4 h-4 group-hover:translate-x-1 transition-transform" />
                        </button>
                      </Link>
                    </div>
                  </article>
                </AnimateOnScroll>
              ))}
            </div>
          </div>
        </section>
      </main>
      <Footer />
    </div>
  );
}

