import { useEffect } from "react";
import Navigation from "@/components/navigation";
import Footer from "@/components/footer";
import { Button } from "@/components/ui/button";
import AnimateOnScroll from "@/components/animate-on-scroll";
import QuoteForm from "@/components/quote-form";
import { CheckCircle, Award, Users, TrendingUp } from "lucide-react";

export default function About() {
  useEffect(() => {
    document.title = "Sobre a KRTI Network Solutions | Automação Residencial de Excelência";
    
    const metaDescription = document.querySelector('meta[name="description"]');
    if (metaDescription) {
      metaDescription.setAttribute('content', 'Conheça a KRTI Network Solutions, especialista em automação residencial e parceiro autorizado Scenario Automation. Mais de 500 projetos realizados e 8 anos de experiência transformando casas em smart homes.');
    }
    
    const metaKeywords = document.querySelector('meta[name="keywords"]');
    if (metaKeywords) {
      metaKeywords.setAttribute('content', 'KRTI Network Solutions, sobre KRTI, automação residencial, Scenario Automation, smart home, empresa automação, parceiro Scenario');
    }
    
    const ogTitle = document.querySelector('meta[property="og:title"]');
    if (ogTitle) {
      ogTitle.setAttribute('content', 'Sobre a KRTI Network Solutions | Automação Residencial');
    }
    
    const ogDescription = document.querySelector('meta[property="og:description"]');
    if (ogDescription) {
      ogDescription.setAttribute('content', 'Especialista em automação residencial com mais de 500 projetos realizados. Parceiro autorizado Scenario Automation.');
    }
  }, []);

  return (
    <div className="min-h-screen bg-background">
      <Navigation />
      <main>
        {/* Hero Section */}
        <section className="relative py-20 lg:py-32 bg-gradient-to-br from-slate-900 via-blue-900 to-slate-900 overflow-hidden">
          <div className="absolute inset-0 tech-gradient"></div>
          <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <AnimateOnScroll direction="up" delay={0.1}>
              <h1 className="text-4xl lg:text-6xl font-bold text-white mb-6">
                <span className="tech-text-gradient">Sobre a KRTI Network Solutions</span>
              </h1>
              <p className="text-xl text-gray-300 max-w-3xl mx-auto">
                Transformando casas em ambientes inteligentes com tecnologia de ponta, 
                expertise técnica e compromisso com a excelência desde 2016.
              </p>
            </AnimateOnScroll>
          </div>
        </section>

        {/* Nossa História */}
        <section className="py-16 lg:py-24 bg-neutral">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="lg:grid lg:grid-cols-2 lg:gap-12 items-center">
              <AnimateOnScroll direction="right" delay={0.1}>
                <img 
                  src="https://images.unsplash.com/photo-1497366216548-37526070297c?w=1200&h=800&fit=crop" 
                  alt="Equipe KRTI Network Solutions especializada em automação residencial" 
                  className="rounded-2xl shadow-xl w-full h-auto"
                />
              </AnimateOnScroll>
              <AnimateOnScroll direction="left" delay={0.2} className="mt-12 lg:mt-0">
                <h2 className="text-3xl lg:text-4xl font-bold mb-6">
                  <span className="tech-text-gradient">Nossa História</span>
                </h2>
                <p className="text-lg text-foreground/90 mb-6 leading-relaxed">
                  A KRTI Network Solutions foi fundada em 2016 com uma visão clara: democratizar o acesso à automação residencial de alta qualidade, tornando a tecnologia de smart home acessível e transformadora para famílias brasileiras.
                </p>
                <p className="text-lg text-foreground/90 mb-6 leading-relaxed">
                  Desde o início, nossa missão tem sido oferecer soluções completas em automação residencial que combinam tecnologia de ponta, design elegante e usabilidade excepcional. Acreditamos que uma casa inteligente deve ser intuitiva, confiável e verdadeiramente transformadora.
                </p>
                <p className="text-lg text-foreground/90 mb-8 leading-relaxed">
                  Ao longo dos anos, nos tornamos referência no mercado brasileiro de automação residencial, realizando mais de 500 projetos bem-sucedidos e estabelecendo parcerias estratégicas com os melhores fabricantes do mundo, incluindo a Scenario Automation.
                </p>
              </AnimateOnScroll>
            </div>
          </div>
        </section>

        {/* Nossa Missão e Valores */}
        <section className="py-16 lg:py-24 bg-background">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <AnimateOnScroll direction="up" delay={0.1}>
              <div className="text-center mb-16">
                <h2 className="text-3xl lg:text-4xl font-bold mb-4">
                  <span className="tech-text-gradient">Missão, Visão e Valores</span>
                </h2>
              </div>
            </AnimateOnScroll>

            <div className="grid md:grid-cols-3 gap-8">
              <AnimateOnScroll direction="up" delay={0.2}>
                <div className="glass-tech rounded-2xl p-8 tech-border-glow h-full">
                  <Award className="w-12 h-12 text-primary mb-4 tech-icon-glow" />
                  <h3 className="text-xl font-semibold text-foreground mb-4">Nossa Missão</h3>
                  <p className="text-foreground/80">
                    Transformar casas em ambientes inteligentes que melhoram a qualidade de vida, 
                    oferecendo soluções de automação residencial de excelência com tecnologia de ponta 
                    e atendimento personalizado.
                  </p>
                </div>
              </AnimateOnScroll>

              <AnimateOnScroll direction="up" delay={0.3}>
                <div className="glass-tech rounded-2xl p-8 tech-border-glow h-full">
                  <TrendingUp className="w-12 h-12 text-primary mb-4 tech-icon-glow" />
                  <h3 className="text-xl font-semibold text-foreground mb-4">Nossa Visão</h3>
                  <p className="text-foreground/80">
                    Ser a empresa líder em automação residencial no Brasil, reconhecida pela excelência 
                    técnica, inovação constante e compromisso com a satisfação total dos clientes, 
                    estabelecendo novos padrões de qualidade no mercado.
                  </p>
                </div>
              </AnimateOnScroll>

              <AnimateOnScroll direction="up" delay={0.4}>
                <div className="glass-tech rounded-2xl p-8 tech-border-glow h-full">
                  <Users className="w-12 h-12 text-primary mb-4 tech-icon-glow" />
                  <h3 className="text-xl font-semibold text-foreground mb-4">Nossos Valores</h3>
                  <ul className="text-foreground/80 space-y-2">
                    <li className="flex items-start">
                      <CheckCircle className="w-5 h-5 text-primary mr-2 mt-0.5 flex-shrink-0" />
                      <span>Excelência técnica e profissionalismo</span>
                    </li>
                    <li className="flex items-start">
                      <CheckCircle className="w-5 h-5 text-primary mr-2 mt-0.5 flex-shrink-0" />
                      <span>Inovação e tecnologia de ponta</span>
                    </li>
                    <li className="flex items-start">
                      <CheckCircle className="w-5 h-5 text-primary mr-2 mt-0.5 flex-shrink-0" />
                      <span>Compromisso com o cliente</span>
                    </li>
                    <li className="flex items-start">
                      <CheckCircle className="w-5 h-5 text-primary mr-2 mt-0.5 flex-shrink-0" />
                      <span>Integridade e transparência</span>
                    </li>
                  </ul>
                </div>
              </AnimateOnScroll>
            </div>
          </div>
        </section>

        {/* Números e Conquistas */}
        <section className="py-16 lg:py-24 bg-neutral">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <AnimateOnScroll direction="up" delay={0.1}>
              <div className="text-center mb-16">
                <h2 className="text-3xl lg:text-4xl font-bold mb-4">
                  <span className="tech-text-gradient">Nossos Números</span>
                </h2>
                <p className="text-xl text-foreground/90 max-w-3xl mx-auto">
                  Resultados que comprovam nossa expertise e compromisso com a excelência
                </p>
              </div>
            </AnimateOnScroll>

            <div className="grid grid-cols-2 md:grid-cols-4 gap-8">
              <AnimateOnScroll direction="up" delay={0.2}>
                <div className="text-center glass-tech rounded-xl p-6 tech-border-glow hover:glow-primary transition-all duration-300">
                  <div className="text-4xl lg:text-5xl font-bold tech-text-gradient mb-2">500+</div>
                  <div className="text-foreground/80 text-lg">Projetos Realizados</div>
                </div>
              </AnimateOnScroll>

              <AnimateOnScroll direction="up" delay={0.3}>
                <div className="text-center glass-tech rounded-xl p-6 tech-border-glow hover:glow-primary transition-all duration-300">
                  <div className="text-4xl lg:text-5xl font-bold tech-text-gradient mb-2">8+</div>
                  <div className="text-foreground/80 text-lg">Anos de Experiência</div>
                </div>
              </AnimateOnScroll>

              <AnimateOnScroll direction="up" delay={0.4}>
                <div className="text-center glass-tech rounded-xl p-6 tech-border-glow hover:glow-primary transition-all duration-300">
                  <div className="text-4xl lg:text-5xl font-bold tech-text-gradient mb-2">98%</div>
                  <div className="text-foreground/80 text-lg">Satisfação dos Clientes</div>
                </div>
              </AnimateOnScroll>

              <AnimateOnScroll direction="up" delay={0.5}>
                <div className="text-center glass-tech rounded-xl p-6 tech-border-glow hover:glow-primary transition-all duration-300">
                  <div className="text-4xl lg:text-5xl font-bold tech-text-gradient mb-2">24/7</div>
                  <div className="text-foreground/80 text-lg">Suporte Técnico</div>
                </div>
              </AnimateOnScroll>
            </div>
          </div>
        </section>

        {/* Parceria Scenario Automation */}
        <section className="py-16 lg:py-24 bg-background">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="lg:grid lg:grid-cols-2 lg:gap-12 items-center">
              <AnimateOnScroll direction="right" delay={0.1}>
                <h2 className="text-3xl lg:text-4xl font-bold mb-6">
                  <span className="tech-text-gradient">Parceiro Autorizado Scenario Automation</span>
                </h2>
                <p className="text-lg text-foreground/90 mb-6 leading-relaxed">
                  A KRTI Network Solutions é parceiro autorizado da Scenario Automation, uma das marcas mais 
                  prestigiadas e inovadoras em automação residencial do mundo. Esta parceria estratégica nos 
                  permite oferecer aos nossos clientes tecnologia de ponta e produtos de qualidade excepcional.
                </p>
                <p className="text-lg text-foreground/90 mb-6 leading-relaxed">
                  Como parceiro autorizado, nossa equipe recebe treinamento contínuo diretamente da Scenario, 
                  garantindo que estamos sempre atualizados com as últimas tecnologias e melhores práticas. 
                  Isso nos permite oferecer instalação, configuração e suporte técnico de nível profissional.
                </p>
                <p className="text-lg text-foreground/90 mb-8 leading-relaxed">
                  Além disso, trabalhamos exclusivamente com produtos originais e garantidos, assegurando 
                  que nossos clientes recebam a melhor experiência possível com seus sistemas de automação residencial.
                </p>
                <Button 
                  onClick={() => window.location.href = "/produtos"}
                  className="bg-primary text-white hover:bg-blue-700 glow-on-hover"
                >
                  Conheça Nossos Produtos
                </Button>
              </AnimateOnScroll>
              <AnimateOnScroll direction="left" delay={0.2} className="mt-12 lg:mt-0">
                <div className="glass-tech rounded-2xl p-8 tech-border-glow">
                  <h3 className="text-2xl font-semibold text-foreground mb-6">Benefícios da Parceria</h3>
                  <ul className="space-y-4">
                    <li className="flex items-start">
                      <CheckCircle className="w-6 h-6 text-primary mr-3 mt-1 flex-shrink-0 tech-icon-glow" />
                      <div>
                        <h4 className="font-semibold text-foreground mb-1">Produtos Originais</h4>
                        <p className="text-foreground/80">Garantia oficial e suporte do fabricante</p>
                      </div>
                    </li>
                    <li className="flex items-start">
                      <CheckCircle className="w-6 h-6 text-primary mr-3 mt-1 flex-shrink-0 tech-icon-glow" />
                      <div>
                        <h4 className="font-semibold text-foreground mb-1">Instalação Certificada</h4>
                        <p className="text-foreground/80">Técnicos treinados e certificados pela Scenario</p>
                      </div>
                    </li>
                    <li className="flex items-start">
                      <CheckCircle className="w-6 h-6 text-primary mr-3 mt-1 flex-shrink-0 tech-icon-glow" />
                      <div>
                        <h4 className="font-semibold text-foreground mb-1">Suporte Especializado</h4>
                        <p className="text-foreground/80">Atendimento técnico dedicado e especializado</p>
                      </div>
                    </li>
                    <li className="flex items-start">
                      <CheckCircle className="w-6 h-6 text-primary mr-3 mt-1 flex-shrink-0 tech-icon-glow" />
                      <div>
                        <h4 className="font-semibold text-foreground mb-1">Atualizações Contínuas</h4>
                        <p className="text-foreground/80">Acesso às últimas tecnologias e atualizações</p>
                      </div>
                    </li>
                  </ul>
                </div>
              </AnimateOnScroll>
            </div>
          </div>
        </section>

        {/* Formulário de Contato */}
        <section className="py-16 lg:py-24 bg-neutral">
          <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <AnimateOnScroll direction="up" delay={0.1}>
              <div className="text-center mb-12">
                <h2 className="text-3xl lg:text-4xl font-bold mb-4">
                  <span className="tech-text-gradient">Entre em Contato</span>
                </h2>
                <p className="text-xl text-foreground/90">
                  Quer saber mais sobre a KRTI? Entre em contato e descubra como podemos transformar sua casa.
                </p>
              </div>
              <QuoteForm source="about-page" />
            </AnimateOnScroll>
          </div>
        </section>
      </main>
      <Footer />
    </div>
  );
}


