import { Home, Shield, Lightbulb, Thermometer, Music, Wrench, ArrowRight } from "lucide-react";
import AnimateOnScroll from "./animate-on-scroll";

const services = [
  {
    icon: Home,
    title: "Automação Completa",
    description: "Integração completa de iluminação, climatização, segurança e entretenimento em um único sistema inteligente.",
  },
  {
    icon: Shield,
    title: "Segurança Inteligente",
    description: "Sistemas de segurança avançados com câmeras IP, sensores de movimento e controle de acesso integrado.",
  },
  {
    icon: Lightbulb,
    title: "Iluminação Inteligente",
    description: "Controle total da iluminação com dimmerização, programação de cenas e automação baseada em presença.",
  },
  {
    icon: Thermometer,
    title: "Climatização Automática",
    description: "Controle inteligente de ar condicionado e aquecimento com economia de energia e conforto máximo.",
  },
  {
    icon: Music,
    title: "Audio & Vídeo",
    description: "Sistemas de som ambiente, home theater e distribuição de áudio/vídeo para toda a residência.",
  },
  {
    icon: Wrench,
    title: "Suporte & Manutenção",
    description: "Suporte técnico especializado, manutenção preventiva e atualizações do sistema para garantir o melhor desempenho.",
  },
];

export default function ServicesSection() {
  return (
    <section id="services" className="py-16 lg:py-24 bg-background">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <AnimateOnScroll direction="up" delay={0.1}>
          <div className="text-center mb-16">
            <h2 className="text-3xl lg:text-4xl font-bold mb-4">
              <span className="tech-text-gradient">Nossos Serviços</span>
            </h2>
            <p className="text-xl text-foreground/90 max-w-3xl mx-auto">
              Oferecemos soluções completas em automação residencial, desde o projeto até a manutenção, 
              sempre com tecnologia de ponta e atendimento personalizado.
            </p>
          </div>
        </AnimateOnScroll>
        
        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
          {services.map((service, index) => {
            const Icon = service.icon;
            return (
              <AnimateOnScroll 
                key={index}
                direction="up" 
                delay={0.1 + index * 0.1}
              >
                <div className="glass-tech rounded-2xl p-8 hover:shadow-lg transition-all duration-300 group h-full tech-border-glow">
                  <div className="w-16 h-16 tech-gradient-strong rounded-xl flex items-center justify-center mb-6 group-hover:glow-primary transition-all duration-300 tech-pulse">
                    <Icon className="w-8 h-8 text-primary tech-icon-glow" />
                  </div>
                  <h3 className="text-xl font-semibold text-foreground mb-4">{service.title}</h3>
                  <p className="text-foreground/80 mb-6">
                    {service.description}
                  </p>
                  <button className="text-primary font-medium hover:text-blue-400 inline-flex items-center group">
                    Saiba mais 
                    <ArrowRight className="w-4 h-4 ml-2 group-hover:translate-x-1 transition-transform" />
                  </button>
                </div>
              </AnimateOnScroll>
            );
          })}
        </div>
      </div>
    </section>
  );
}
