import { Star, Medal, UserCheck, Headphones } from "lucide-react";
import AnimateOnScroll from "./animate-on-scroll";

const features = [
  "Keypads Prestige e Essence para controle intuitivo",
  "Touch Walls com interface touchscreen elegante",
  "Remote para controle sofisticado sem fio",
  "App móvel com controle total da casa",
  "Inteligência Embrace com automação avançada",
];

const highlights = [
  {
    icon: Medal,
    title: "Revendedor Autorizado",
    description: "Produtos originais com garantia oficial",
  },
  {
    icon: UserCheck,
    title: "Instalação Certificada",
    description: "Técnicos treinados pela Scenario",
  },
  {
    icon: Headphones,
    title: "Suporte Especializado",
    description: "Atendimento técnico dedicado",
  },
];

export default function ProductsSection() {
  return (
    <section id="products" className="py-16 lg:py-24 bg-gradient-to-br from-secondary to-slate-800">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <AnimateOnScroll direction="up" delay={0.1}>
          <div className="text-center mb-16">
            <h2 className="text-3xl lg:text-4xl font-bold text-white mb-4">
              Parceria com Scenario Automation
            </h2>
            <p className="text-xl text-gray-300 max-w-3xl mx-auto">
              Como revendedor autorizado, oferecemos toda a linha de produtos Scenario Automation 
              com garantia oficial e suporte técnico especializado.
            </p>
          </div>
        </AnimateOnScroll>
        
        <div className="lg:grid lg:grid-cols-2 lg:gap-12 items-center mb-16">
          <AnimateOnScroll direction="right" delay={0.2}>
            <div className="grid grid-cols-2 gap-4">
              <img 
                src="https://scenarioautomation.com/assets/images/kps-596x514.png" 
                alt="Keypads Scenario Automation" 
                className="rounded-xl shadow-lg w-full h-auto"
              />
              <img 
                src="https://scenarioautomation.com/assets/images/tws-596x514.png" 
                alt="Touch Wall Scenario Automation" 
                className="rounded-xl shadow-lg w-full h-auto"
              />
              <img 
                src="https://scenarioautomation.com/assets/images/remote-596x514.png" 
                alt="Remote Scenario Automation" 
                className="rounded-xl shadow-lg w-full h-auto"
              />
              <img 
                src="https://scenarioautomation.com/assets/images/prod4-app.png" 
                alt="App Scenario Automation" 
                className="rounded-xl shadow-lg w-full h-auto"
              />
            </div>
          </AnimateOnScroll>
          <AnimateOnScroll direction="left" delay={0.3} className="mt-12 lg:mt-0">
            <div className="glass-tech-strong rounded-2xl p-8 tech-border-glow">
              <h3 className="text-2xl font-semibold text-white mb-6">
                <span className="tech-text-gradient">Tecnologia Scenario Automation</span>
              </h3>
              <ul className="space-y-4 text-gray-200">
                {features.map((feature, index) => (
                  <li key={index} className="flex items-start">
                    <Star className="w-5 h-5 text-accent mr-3 mt-1 flex-shrink-0 tech-icon-glow" />
                    <span>{feature}</span>
                  </li>
                ))}
              </ul>
            </div>
          </AnimateOnScroll>
        </div>
        
        <div className="grid md:grid-cols-3 gap-8">
          {highlights.map((highlight, index) => {
            const Icon = highlight.icon;
            return (
              <AnimateOnScroll 
                key={index}
                direction="up" 
                delay={0.2 + index * 0.1}
              >
                <div className="glass-tech rounded-xl p-6 tech-border-glow text-center h-full hover:glow-primary transition-all duration-300">
                  <div className="w-16 h-16 tech-gradient-strong rounded-full flex items-center justify-center mx-auto mb-4 tech-pulse">
                    <Icon className="w-8 h-8 text-accent tech-icon-glow" />
                  </div>
                  <h4 className="text-lg font-semibold text-white mb-2">{highlight.title}</h4>
                  <p className="text-gray-300">{highlight.description}</p>
                </div>
              </AnimateOnScroll>
            );
          })}
        </div>
      </div>
    </section>
  );
}
