import { useState } from "react";
import { Button } from "@/components/ui/button";
import { Menu, X } from "lucide-react";
import { Link } from "wouter";
import logoKrti from "../assets/logo-krti.png";

export default function Navigation() {
  const [isMenuOpen, setIsMenuOpen] = useState(false);

  const scrollToSection = (sectionId: string) => {
    const element = document.getElementById(sectionId);
    if (element) {
      element.scrollIntoView({ behavior: "smooth" });
      setIsMenuOpen(false);
    }
  };

  return (
    <nav className="glass-tech-strong shadow-lg border-b border-primary/20 sticky top-0 z-50 backdrop-blur-xl">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="flex justify-between items-center h-20">
          <div className="flex items-center">
            <Link href="/">
              <div className="flex-shrink-0 cursor-pointer">
                <img 
                  src={logoKrti} 
                  alt="KRTI Network Solutions" 
                  className="h-14 w-auto brightness-0 invert"
                />
              </div>
            </Link>
          </div>
          
          <div className="hidden md:block">
            <div className="ml-10 flex items-baseline space-x-8">
              <Link href="/">
                <button className="text-primary font-medium hover:text-blue-400 transition-colors">
                  Início
                </button>
              </Link>
              <Link href="/sobre">
                <button className="text-foreground hover:text-primary transition-colors">
                  Sobre
                </button>
              </Link>
              <Link href="/servicos">
                <button className="text-foreground hover:text-primary transition-colors">
                  Serviços
                </button>
              </Link>
              <Link href="/produtos">
                <button className="text-foreground hover:text-primary transition-colors">
                  Produtos
                </button>
              </Link>
              <Link href="/blog">
                <button className="text-foreground hover:text-primary transition-colors">
                  Blog
                </button>
              </Link>
              <Link href="/contato">
                <Button className="bg-primary text-white hover:bg-blue-700 glow-on-hover">
                  Contato
                </Button>
              </Link>
            </div>
          </div>
          
          <div className="md:hidden">
            <Button
              variant="ghost"
              size="icon"
              onClick={() => setIsMenuOpen(!isMenuOpen)}
              className="text-foreground hover:text-primary"
            >
              {isMenuOpen ? <X className="h-6 w-6" /> : <Menu className="h-6 w-6" />}
            </Button>
          </div>
        </div>
      </div>
      
      {/* Mobile menu */}
      {isMenuOpen && (
        <div className="md:hidden bg-background border-t border-border">
          <div className="px-2 pt-2 pb-3 space-y-1">
            <Link href="/">
              <button className="block w-full text-left px-3 py-2 text-primary font-medium">
                Início
              </button>
            </Link>
            <Link href="/sobre">
              <button className="block w-full text-left px-3 py-2 text-foreground hover:text-primary">
                Sobre
              </button>
            </Link>
            <Link href="/servicos">
              <button className="block w-full text-left px-3 py-2 text-foreground hover:text-primary">
                Serviços
              </button>
            </Link>
            <Link href="/produtos">
              <button className="block w-full text-left px-3 py-2 text-foreground hover:text-primary">
                Produtos
              </button>
            </Link>
            <Link href="/blog">
              <button className="block w-full text-left px-3 py-2 text-foreground hover:text-primary">
                Blog
              </button>
            </Link>
            <Link href="/contato">
              <button className="block w-full text-left px-3 py-2 text-foreground hover:text-primary">
                Contato
              </button>
            </Link>
          </div>
        </div>
      )}
    </nav>
  );
}
