import { Button } from "@/components/ui/button";
import { CheckCircle } from "lucide-react";
import bannerKrti from "../assets/banner-krti.jpg";
import AnimateOnScroll from "./animate-on-scroll";

export default function HeroSection() {
  const scrollToSection = (sectionId: string) => {
    const element = document.getElementById(sectionId);
    if (element) {
      element.scrollIntoView({ behavior: "smooth" });
    }
  };

  return (
    <section 
      id="home" 
      className="relative bg-gradient-to-br from-slate-900 via-blue-900 to-slate-900 overflow-hidden tech-particles"
    >
      <div className="absolute inset-0 bg-black/60"></div>
      <div className="absolute inset-0 tech-gradient"></div>
      <div 
        className="absolute inset-0 bg-cover bg-center opacity-30"
        style={{
          backgroundImage: `url(${bannerKrti})`
        }}
      ></div>
      <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-24 lg:py-32">
        <div className="lg:grid lg:grid-cols-2 lg:gap-12 items-center">
          <AnimateOnScroll direction="right" delay={0.2}>
            <h1 className="text-4xl lg:text-6xl font-bold text-white mb-6 leading-tight">
              Transforme sua casa em um
              <span className="tech-text-gradient"> ambiente inteligente</span>
            </h1>
            <p className="text-xl text-gray-200 mb-8 leading-relaxed">
              Soluções completas em automação residencial com tecnologia de ponta. 
              Parceiro autorizado Scenario Automation para oferecer o melhor em casa inteligente.
            </p>
            <div className="flex flex-col sm:flex-row gap-4">
              <Button 
                onClick={() => scrollToSection("contact")}
                className="bg-primary text-white px-8 py-4 text-lg font-semibold hover:bg-blue-700 h-auto glow-on-hover tech-border-glow"
              >
                Solicitar Consultoria
              </Button>
              <Button 
                onClick={() => scrollToSection("products")}
                className="glass-tech text-white px-8 py-4 text-lg font-semibold hover:bg-white/20 h-auto border border-white/30"
              >
                Ver Produtos
              </Button>
            </div>
          </AnimateOnScroll>
          <AnimateOnScroll direction="left" delay={0.4} className="mt-12 lg:mt-0">
            <div className="glass-tech-strong rounded-2xl p-8 tech-border-glow">
              <h3 className="text-2xl font-semibold text-white mb-4 flex items-center">
                <span className="tech-text-gradient">Por que escolher a KRTI?</span>
              </h3>
              <ul className="space-y-3 text-gray-200">
                <li className="flex items-center">
                  <CheckCircle className="w-5 h-5 text-accent mr-3 tech-icon-glow" />
                  Parceiro autorizado Scenario Automation
                </li>
                <li className="flex items-center">
                  <CheckCircle className="w-5 h-5 text-accent mr-3 tech-icon-glow" />
                  Instalação e suporte técnico especializado
                </li>
                <li className="flex items-center">
                  <CheckCircle className="w-5 h-5 text-accent mr-3 tech-icon-glow" />
                  Soluções personalizadas para cada projeto
                </li>
                <li className="flex items-center">
                  <CheckCircle className="w-5 h-5 text-accent mr-3 tech-icon-glow" />
                  Garantia e manutenção pós-venda
                </li>
              </ul>
            </div>
          </AnimateOnScroll>
        </div>
      </div>
    </section>
  );
}
