import { Instagram } from "lucide-react";
import logoKrti from "../assets/logo-krti.png";

export default function Footer() {
  const scrollToSection = (sectionId: string) => {
    const element = document.getElementById(sectionId);
    if (element) {
      element.scrollIntoView({ behavior: "smooth" });
    }
  };

  return (
    <footer className="bg-black text-white py-12">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="grid md:grid-cols-4 gap-8 mb-8">
          <div>
            <img 
              src={logoKrti} 
              alt="KRTI Network Solutions" 
              className="h-10 w-auto mb-4 brightness-0 invert"
            />
            <p className="text-gray-300 mb-4">
              Transformando casas em ambientes inteligentes com tecnologia de ponta 
              e atendimento personalizado.
            </p>
            <div className="flex space-x-4">
              <a 
                href="https://www.instagram.com/krtinetworksolutions/" 
                target="_blank" 
                rel="noopener noreferrer"
                className="text-gray-300 hover:text-accent transition-colors"
              >
                <Instagram className="w-6 h-6" />
              </a>
            </div>
          </div>
          
          <div>
            <h4 className="font-semibold mb-4">Serviços</h4>
            <ul className="space-y-2 text-gray-300">
              <li>
                <button 
                  onClick={() => scrollToSection("services")}
                  className="hover:text-accent transition-colors text-left"
                >
                  Automação Completa
                </button>
              </li>
              <li>
                <button 
                  onClick={() => scrollToSection("services")}
                  className="hover:text-accent transition-colors text-left"
                >
                  Segurança Inteligente
                </button>
              </li>
              <li>
                <button 
                  onClick={() => scrollToSection("services")}
                  className="hover:text-accent transition-colors text-left"
                >
                  Iluminação
                </button>
              </li>
              <li>
                <button 
                  onClick={() => scrollToSection("services")}
                  className="hover:text-accent transition-colors text-left"
                >
                  Audio & Vídeo
                </button>
              </li>
            </ul>
          </div>
          
          <div>
            <h4 className="font-semibold mb-4">Empresa</h4>
            <ul className="space-y-2 text-gray-300">
              <li>
                <button 
                  onClick={() => scrollToSection("about")}
                  className="hover:text-accent transition-colors text-left"
                >
                  Sobre Nós
                </button>
              </li>
              <li>
                <button 
                  onClick={() => scrollToSection("products")}
                  className="hover:text-accent transition-colors text-left"
                >
                  Scenario Automation
                </button>
              </li>
              <li>
                <button 
                  onClick={() => scrollToSection("contact")}
                  className="hover:text-accent transition-colors text-left"
                >
                  Contato
                </button>
              </li>
              <li>
                <button 
                  onClick={() => scrollToSection("contact")}
                  className="hover:text-accent transition-colors text-left"
                >
                  Suporte
                </button>
              </li>
            </ul>
          </div>
          
          <div>
            <h4 className="font-semibold mb-4">Contato</h4>
            <ul className="space-y-2 text-gray-300">
              <li>suporte@krti.com.br</li>
              <li>@krtinetworksolutions</li>
              <li>Segunda a Sexta: 8h às 18h</li>
              <li>Sábado: 8h às 12h</li>
            </ul>
          </div>
        </div>
        
        <div className="border-t border-gray-700 pt-8 flex flex-col md:flex-row justify-between items-center">
          <p className="text-gray-300 text-sm">
            © 2024 KRTI Network Solutions. Todos os direitos reservados.
          </p>
          <p className="text-gray-300 text-sm mt-4 md:mt-0">
            Parceiro autorizado Scenario Automation
          </p>
        </div>
      </div>
    </footer>
  );
}
