import { Calendar, Clock, ArrowRight } from "lucide-react";
import AnimateOnScroll from "./animate-on-scroll";
import { Link } from "wouter";

interface BlogPost {
  id: string;
  title: string;
  excerpt: string;
  author: string;
  date: string;
  readTime: string;
  category: string;
  image: string;
}

const blogPosts: BlogPost[] = [
  {
    id: "1",
    title: "Como Transformar sua Casa em uma Smart Home Completa",
    excerpt: "Descubra os passos essenciais para transformar sua residência em um ambiente totalmente automatizado e inteligente, com dicas práticas e soluções inovadoras.",
    author: "KRTI Team",
    date: "15 de Janeiro, 2025",
    readTime: "12 min",
    category: "Automação",
    image: "https://images.unsplash.com/photo-1558618666-fcd25c85cd64?w=800&h=600&fit=crop"
  },
  {
    id: "2",
    title: "Iluminação Inteligente: Economia e Conforto em um Sistema",
    excerpt: "Aprenda como a iluminação inteligente pode reduzir seus custos de energia em até 40% enquanto proporciona o máximo conforto e personalização para cada ambiente.",
    author: "KRTI Team",
    date: "10 de Janeiro, 2025",
    readTime: "10 min",
    category: "Iluminação",
    image: "https://images.unsplash.com/photo-1513475382585-d06e58bcb0e0?w=800&h=600&fit=crop"
  },
  {
    id: "3",
    title: "Segurança Inteligente: Proteja sua Casa com Tecnologia de Ponta",
    excerpt: "Conheça as soluções mais avançadas em segurança residencial, incluindo câmeras inteligentes, sensores de movimento e sistemas de alarme integrados.",
    author: "KRTI Team",
    date: "5 de Janeiro, 2025",
    readTime: "11 min",
    category: "Segurança",
    image: "https://images.unsplash.com/photo-1557804506-669a67965ba0?w=800&h=600&fit=crop"
  },
  {
    id: "4",
    title: "Scenario Automation: A Tecnologia que Revoluciona sua Casa",
    excerpt: "Explore as funcionalidades exclusivas da tecnologia Scenario Automation e descubra como ela pode transformar completamente sua experiência de morar.",
    author: "KRTI Team",
    date: "28 de Janeiro, 2025",
    readTime: "12 min",
    category: "Tecnologia",
    image: "https://images.unsplash.com/photo-1484154218962-a197022b5858?w=800&h=600&fit=crop"
  },
  {
    id: "5",
    title: "Climatização Automática: Conforto Inteligente em Todos os Ambientes",
    excerpt: "Entenda como sistemas de climatização inteligente podem manter sua casa na temperatura ideal automaticamente, economizando energia e garantindo conforto.",
    author: "KRTI Team",
    date: "20 de Janeiro, 2025",
    readTime: "11 min",
    category: "Climatização",
    image: "https://images.unsplash.com/photo-1581578731548-c64695cc6952?w=800&h=600&fit=crop"
  },
  {
    id: "6",
    title: "Audio & Vídeo: Transforme sua Casa em um Cinema",
    excerpt: "Descubra como sistemas de áudio e vídeo distribuídos podem transformar qualquer ambiente da sua casa em uma experiência cinematográfica de alta qualidade.",
    author: "KRTI Team",
    date: "15 de Janeiro, 2025",
    readTime: "11 min",
    category: "Audio & Vídeo",
    image: "https://images.unsplash.com/photo-1493225457124-a3eb161ffa5f?w=800&h=600&fit=crop"
  },
];

export default function BlogSection() {
  // Get first 6 posts
  const featuredPosts = blogPosts.slice(0, 6);

  return (
    <section className="py-16 lg:py-24 bg-background">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <AnimateOnScroll direction="up" delay={0.1}>
          <div className="text-center mb-16">
            <h2 className="text-3xl lg:text-4xl font-bold mb-4">
              <span className="tech-text-gradient">Últimos Artigos do Blog</span>
            </h2>
            <p className="text-xl text-foreground/90 max-w-3xl mx-auto">
              Fique por dentro das últimas tendências e novidades em automação residencial
            </p>
          </div>
        </AnimateOnScroll>

        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
          {featuredPosts.map((post, index) => (
            <AnimateOnScroll 
              key={post.id}
              direction="up" 
              delay={0.1 + index * 0.1}
            >
              <Link href={`/blog/${post.id}`}>
                <article className="glass-tech rounded-2xl overflow-hidden hover:shadow-xl transition-all duration-300 tech-border-glow group h-full flex flex-col cursor-pointer">
                  <div className="relative h-48 overflow-hidden">
                    <img 
                      src={post.image} 
                      alt={post.title}
                      className="w-full h-full object-cover group-hover:scale-110 transition-transform duration-300"
                    />
                    <div className="absolute top-4 left-4">
                      <span className="bg-primary/90 text-white px-3 py-1 rounded-full text-sm font-medium">
                        {post.category}
                      </span>
                    </div>
                  </div>
                  <div className="p-6 flex-1 flex flex-col">
                    <h3 className="text-xl font-semibold text-foreground mb-3 group-hover:text-primary transition-colors line-clamp-2">
                      {post.title}
                    </h3>
                    <p className="text-foreground/80 mb-4 flex-1 line-clamp-3">
                      {post.excerpt}
                    </p>
                    <div className="flex items-center text-sm text-foreground/60 mb-4 space-x-4">
                      <div className="flex items-center">
                        <Calendar className="w-4 h-4 mr-2" />
                        {post.date}
                      </div>
                      <div className="flex items-center">
                        <Clock className="w-4 h-4 mr-2" />
                        {post.readTime}
                      </div>
                    </div>
                    <Link href={`/blog/${post.id}`}>
                      <button className="text-primary font-medium hover:text-blue-400 inline-flex items-center group w-full justify-between">
                        <span>Ler mais</span>
                        <ArrowRight className="w-4 h-4 group-hover:translate-x-1 transition-transform" />
                      </button>
                    </Link>
                  </div>
                </article>
              </Link>
            </AnimateOnScroll>
          ))}
        </div>

        <AnimateOnScroll direction="up" delay={0.7}>
          <div className="text-center mt-12">
            <Link href="/blog">
              <button className="bg-primary text-white hover:bg-blue-700 px-8 py-3 rounded-lg font-semibold transition-colors glow-on-hover">
                Ver Todos os Artigos
              </button>
            </Link>
          </div>
        </AnimateOnScroll>
      </div>
    </section>
  );
}

