import { Button } from "@/components/ui/button";
import AnimateOnScroll from "./animate-on-scroll";

export default function AboutSection() {
  return (
    <section id="about" className="py-16 lg:py-24 bg-neutral">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="lg:grid lg:grid-cols-2 lg:gap-12 items-center">
          <AnimateOnScroll direction="right" delay={0.1}>
            <img 
              src="https://images.unsplash.com/photo-1497366216548-37526070297c?ixlib=rb-4.0.3&ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&auto=format&fit=crop&w=800&h=600" 
              alt="Escritório moderno com tecnologia de automação" 
              className="rounded-2xl shadow-xl w-full h-auto"
            />
          </AnimateOnScroll>
          <AnimateOnScroll direction="left" delay={0.2} className="mt-12 lg:mt-0">
            <h2 className="text-3xl lg:text-4xl font-bold mb-6">
              <span className="tech-text-gradient">Sobre a KRTI Network Solutions</span>
            </h2>
            <p className="text-lg text-foreground/90 mb-6 leading-relaxed">
              A KRTI é uma empresa especializada em automação residencial, oferecendo soluções 
              inteligentes que transformam casas em ambientes conectados, seguros e eficientes.
            </p>
            <p className="text-lg text-foreground/90 mb-8 leading-relaxed">
              Como parceiro autorizado da Scenario Automation, garantimos produtos de alta qualidade 
              e tecnologia de ponta, sempre com suporte técnico especializado e atendimento personalizado.
            </p>
            
            <div className="grid grid-cols-2 gap-6 mb-8">
              <div className="text-center glass-tech rounded-xl p-6 tech-border-glow hover:glow-primary transition-all duration-300">
                <div className="text-3xl font-bold tech-text-gradient mb-2">500+</div>
                <div className="text-foreground/80">Projetos Realizados</div>
              </div>
              <div className="text-center glass-tech rounded-xl p-6 tech-border-glow hover:glow-primary transition-all duration-300">
                <div className="text-3xl font-bold tech-text-gradient mb-2">8+</div>
                <div className="text-foreground/80">Anos de Experiência</div>
              </div>
            </div>
            
            <Button 
              onClick={() => {
                const element = document.getElementById("contact");
                if (element) element.scrollIntoView({ behavior: "smooth" });
              }}
              className="bg-primary text-white hover:bg-blue-700"
            >
              Saiba Mais Sobre Nós
            </Button>
          </AnimateOnScroll>
        </div>
      </div>
    </section>
  );
}
