# Configuração PHP para Envio de Emails

## Opção 1: Usar PHP Standalone (Recomendado)

Se você tem um servidor com PHP instalado, pode usar os arquivos PHP diretamente:

### Arquivos PHP criados:
- `server/send-email.php` - Endpoint para envio de emails
- `server/contact-form.php` - Formulário HTML standalone

### Como usar:

1. **Copie os arquivos PHP para um servidor web com PHP:**
   ```bash
   cp server/send-email.php /var/www/html/
   cp server/contact-form.php /var/www/html/
   ```

2. **Acesse o formulário:**
   ```
   http://seu-servidor.com/contact-form.php
   ```

3. **Ou use o endpoint diretamente:**
   ```javascript
   fetch('http://seu-servidor.com/send-email.php', {
     method: 'POST',
     headers: { 'Content-Type': 'application/json' },
     body: JSON.stringify({
       name: 'Nome',
       email: 'email@example.com',
       phone: '(11) 99999-9999',
       projectType: 'automacao-completa',
       message: 'Mensagem',
       source: 'website'
     })
   })
   ```

## Opção 2: Usar via Node.js (Atual)

O sistema atual usa Node.js como proxy. O endpoint `/send-email.php` no Express funciona como proxy e usa o serviço de email Node.js.

### Configuração necessária:

1. **Variáveis de ambiente** (arquivo `.env`):
   ```env
   EMAIL_USER=seu-email@gmail.com
   EMAIL_PASS=sua-app-password
   EMAIL_FROM=noreply@krti.com.br
   ```

2. **O email será enviado para:** `vgsalatiel@gmail.com`

## Testando

### Via React (atual):
- Acesse qualquer formulário no site
- Todos os formulários agora usam `/send-email.php`

### Via PHP direto:
- Acesse: `http://localhost:5000/contact-form.php` (se configurado)
- Ou copie os arquivos para um servidor PHP

## Notas Importantes

- O email de destino está configurado para: **vgsalatiel@gmail.com**
- Todos os formulários do site (React) agora usam o endpoint `/send-email.php`
- O endpoint funciona tanto via Node.js quanto pode ser substituído por PHP puro


