# Configuração de Email

## Email de Destino
Por padrão, todos os emails são enviados para: **vgsalatiel@gmail.com**

## Configuração do Servidor de Email

### Opção 1: Gmail (Recomendado para testes)

1. **Criar uma App Password no Gmail:**
   - Acesse: https://myaccount.google.com/apppasswords
   - Selecione "Email" e "Outro (nome personalizado)"
   - Digite "KRTI Network" e clique em "Gerar"
   - Copie a senha gerada (16 caracteres)

2. **Configurar variáveis de ambiente:**
   Crie um arquivo `.env` na raiz do projeto:
   ```env
   EMAIL_USER=seu-email@gmail.com
   EMAIL_PASS=sua-app-password-gerada
   EMAIL_FROM=noreply@krti.com.br
   ```

### Opção 2: SMTP Genérico

Para usar outro provedor de email, edite `server/email.ts` e descomente a seção SMTP genérico:

```env
SMTP_HOST=smtp.seu-provedor.com
SMTP_PORT=587
EMAIL_USER=seu-email@provedor.com
EMAIL_PASS=sua-senha
```

## Testar o Envio de Email

1. Acesse: `http://localhost:5000/test-email`
2. Preencha o formulário
3. Clique em "Enviar Email de Teste"
4. Verifique a caixa de entrada de vgsalatiel@gmail.com

## Notas Importantes

- O email de destino está hardcoded para `vgsalatiel@gmail.com` no código
- Todos os formulários de contato do site enviarão emails para este endereço
- Certifique-se de ter configurado as variáveis de ambiente antes de testar

